/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ru.turikhay.tlauncher.bootstrap.launcher.InternalLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalCastingLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import shaded.com.google.gson.JsonSyntaxException;
import shaded.org.apache.commons.io.IOUtils;
import shaded.org.apache.commons.lang3.builder.ToStringBuilder;

public class InternalLauncher
extends LocalCastingLauncher {
    private final URL url = this.getClass().getResource("/launcher.jar");
    private Path tempFile;

    public InternalLauncher() throws LauncherNotFoundException {
        if (this.url == null) {
            throw new LauncherNotFoundException("internal");
        }
    }

    private InputStream getInputStream() throws IOException {
        if (this.tempFile != null) {
            return Files.newInputStream(this.tempFile, new OpenOption[0]);
        }
        return this.url.openStream();
    }

    private Path getTempFile() throws IOException {
        if (this.tempFile == null) {
            Path temp = Files.createTempFile("tlauncher", null, new FileAttribute[0]);
            this.unpack(Files.newOutputStream(temp, new OpenOption[0]));
            this.tempFile = temp;
        }
        return this.tempFile;
    }

    private void unpack(OutputStream out) throws IOException {
        IOUtils.copy(this.getInputStream(), out);
    }

    @Override
    public InternalLauncherMeta getMeta() throws IOException, JsonSyntaxException {
        return LocalLauncher.findMetaEntry(this.getTempFile(), InternalLauncherMeta.class);
    }

    @Override
    public Task<LocalLauncher> toLocalLauncher(final Path file, final Path libFolder) {
        return new Task<LocalLauncher>("internalToLocalLauncher"){

            @Override
            protected LocalLauncher execute() throws Exception {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                InternalLauncher.this.unpack(Files.newOutputStream(file, new OpenOption[0]));
                try {
                    return new LocalLauncher(file, libFolder);
                }
                catch (LauncherNotFoundException lnfE) {
                    throw new IOException(lnfE);
                }
            }
        };
    }

    @Override
    public ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("url", this.url).append("tempFile", this.tempFile);
    }
}

