/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import ru.turikhay.tlauncher.bootstrap.json.ExposeExclusion;
import ru.turikhay.tlauncher.bootstrap.json.LocaleDeserializer;
import ru.turikhay.tlauncher.bootstrap.json.VersionJsonizer;
import shaded.com.github.zafarkhaja.semver.Version;
import shaded.com.google.gson.Gson;
import shaded.com.google.gson.GsonBuilder;
import shaded.com.google.gson.JsonDeserializationContext;
import shaded.com.google.gson.JsonElement;
import shaded.com.google.gson.JsonObject;
import shaded.com.google.gson.JsonParseException;
import shaded.com.google.gson.JsonSyntaxException;
import shaded.org.apache.commons.lang3.Validate;

public final class Json {
    private static final Gson GSON = Json.build().create();

    public static <T> T parse(InputStream in, Type type) throws JsonSyntaxException {
        return Json.get().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), type);
    }

    public static Gson get() {
        return GSON;
    }

    public static GsonBuilder build() {
        return ExposeExclusion.setup(new GsonBuilder()).registerTypeAdapter((Type)((Object)Locale.class), new LocaleDeserializer()).registerTypeAdapter((Type)((Object)Version.class), new VersionJsonizer());
    }

    public static JsonElement require(JsonObject o, String key) {
        if (o.has(key)) {
            return o.get(key);
        }
        throw new JsonParseException("missing required key \"" + key + "\"");
    }

    public static <T> T parse(JsonDeserializationContext ctx, JsonObject o, String key, Type type, boolean require) {
        Object value;
        if (o.has(key)) {
            try {
                value = Validate.notNull(ctx.deserialize(o.get(key), type), key, new Object[0]);
            }
            catch (RuntimeException rE) {
                if (require) {
                    throw new JsonParseException("error deserializing key \"" + key + "\" in " + o, rE);
                }
                return null;
            }
        } else {
            if (require) {
                throw new JsonParseException("required key: \"" + key + "\"");
            }
            return null;
        }
        return value;
    }

    public static <T> T parse(JsonDeserializationContext ctx, JsonObject o, String key, Type type) {
        return Json.parse(ctx, o, key, type, true);
    }

    private Json() {
        throw new NoSuchMethodError();
    }
}

