/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.bridge;

import java.util.UUID;
import ru.turikhay.tlauncher.bootstrap.bridge.BootBridge;
import ru.turikhay.tlauncher.bootstrap.bridge.BootException;
import ru.turikhay.tlauncher.bootstrap.bridge.BootListener;
import ru.turikhay.tlauncher.bootstrap.bridge.BootMessage;

public final class BootEventDispatcher
implements BootListener {
    private final BootBridge bridge;
    private boolean booting;
    private boolean working;
    private double percentage;
    private Throwable error;

    BootEventDispatcher(BootBridge bridge) {
        if (bridge == null) {
            throw new NullPointerException("bridge");
        }
        this.bridge = bridge;
    }

    public void passClient(UUID client) {
        this.bridge.setClient(client);
    }

    public Throwable getError() {
        return this.error;
    }

    public BootMessage getBootMessage(String locale) {
        return this.bridge.getMessage(locale);
    }

    @Override
    public void onBootStarted() throws InterruptedException {
        if (this.booting || this.working) {
            throw new IllegalStateException("booting: " + this.booting + "; working:" + this.working);
        }
        this.checkInterrupted();
        for (BootListener l : this.bridge.listenerList) {
            l.onBootStarted();
        }
        this.booting = true;
        this.log("Boot started");
    }

    @Override
    public void onBootStateChanged(String stepName, double percentage) throws InterruptedException {
        if (!this.booting || this.working) {
            throw new IllegalStateException("booting: " + this.booting + "; working:" + this.working);
        }
        if (percentage < this.percentage) {
            throw new IllegalArgumentException("percentage is lower than prevoius value: " + percentage + " (expecting bigger than " + this.percentage + ")");
        }
        if (percentage > 1.0) {
            throw new IllegalArgumentException("percentage is above 1.0");
        }
        this.checkInterrupted();
        for (BootListener l : this.bridge.listenerList) {
            l.onBootStateChanged(stepName, percentage);
        }
        this.percentage = percentage;
        this.log("Boot state changed: \"" + stepName + "\", " + percentage);
    }

    @Override
    public void onBootSucceeded() throws InterruptedException {
        if (!this.booting || this.working) {
            throw new IllegalStateException("booting: " + this.booting + "; working:" + this.working);
        }
        this.checkInterrupted();
        for (BootListener l : this.bridge.listenerList) {
            l.onBootSucceeded();
        }
        this.booting = false;
        this.working = true;
        this.log("Boot finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootErrored(Throwable t) throws InterruptedException {
        for (BootListener l : this.bridge.listenerList) {
            l.onBootErrored(t);
        }
        this.booting = false;
        this.working = false;
        this.error = t;
        BootEventDispatcher bootEventDispatcher = this;
        synchronized (bootEventDispatcher) {
            this.notifyAll();
        }
        this.log("Boot errored");
        t.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilClose() throws InterruptedException, BootException {
        this.checkInterrupted();
        while (this.booting || this.working) {
            BootEventDispatcher bootEventDispatcher = this;
            synchronized (bootEventDispatcher) {
                this.wait();
            }
        }
        if (this.error != null) {
            throw new BootException(this.error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClose() {
        this.log("Close operation requested");
        this.working = false;
        BootEventDispatcher bootEventDispatcher = this;
        synchronized (bootEventDispatcher) {
            this.notifyAll();
        }
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return;
            }
            this.log("Closing forcefully!");
            System.exit(-1);
        }).start();
    }

    private void checkInterrupted() throws InterruptedException {
        if (this.bridge.interrupted) {
            throw new InterruptedException("external interrupt");
        }
    }

    private void log(String s) {
        System.out.println("[BootEventDisp] " + s);
    }
}

