/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import ru.turikhay.tlauncher.bootstrap.TargetConfig;
import ru.turikhay.tlauncher.bootstrap.Updater;
import ru.turikhay.tlauncher.bootstrap.bridge.BootBridge;
import ru.turikhay.tlauncher.bootstrap.bridge.BootListenerAdapter;
import ru.turikhay.tlauncher.bootstrap.bridge.FlatLafConfiguration;
import ru.turikhay.tlauncher.bootstrap.exception.FatalExceptionType;
import ru.turikhay.tlauncher.bootstrap.launcher.ClassLoaderStarter;
import ru.turikhay.tlauncher.bootstrap.launcher.InternalLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LauncherNotFoundException;
import ru.turikhay.tlauncher.bootstrap.launcher.Library;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncher;
import ru.turikhay.tlauncher.bootstrap.launcher.LocalLauncherTask;
import ru.turikhay.tlauncher.bootstrap.launcher.RemoteLauncher;
import ru.turikhay.tlauncher.bootstrap.meta.DownloadEntry;
import ru.turikhay.tlauncher.bootstrap.meta.LocalBootstrapMeta;
import ru.turikhay.tlauncher.bootstrap.meta.LocalLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteBootstrapMeta;
import ru.turikhay.tlauncher.bootstrap.meta.RemoteLauncherMeta;
import ru.turikhay.tlauncher.bootstrap.meta.UpdateMeta;
import ru.turikhay.tlauncher.bootstrap.ssl.FixSSL;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskInterruptedException;
import ru.turikhay.tlauncher.bootstrap.task.TaskList;
import ru.turikhay.tlauncher.bootstrap.transport.SignedStream;
import ru.turikhay.tlauncher.bootstrap.ui.HeadlessInterface;
import ru.turikhay.tlauncher.bootstrap.ui.IInterface;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.ui.flatlaf.FlatLaf;
import ru.turikhay.tlauncher.bootstrap.util.CombinedOptionSet;
import ru.turikhay.tlauncher.bootstrap.util.Compressor;
import ru.turikhay.tlauncher.bootstrap.util.OS;
import ru.turikhay.tlauncher.bootstrap.util.PathValueConverter;
import ru.turikhay.tlauncher.bootstrap.util.Sha256Sign;
import ru.turikhay.tlauncher.bootstrap.util.SplitArgs;
import ru.turikhay.tlauncher.bootstrap.util.U;
import ru.turikhay.tlauncher.bootstrap.util.stream.OutputRedirectBuffer;
import ru.turikhay.util.JavaVersion;
import shaded.com.getsentry.raven.DefaultRavenFactory;
import shaded.com.getsentry.raven.Raven;
import shaded.com.getsentry.raven.dsn.Dsn;
import shaded.com.getsentry.raven.event.Event;
import shaded.com.getsentry.raven.event.EventBuilder;
import shaded.com.getsentry.raven.event.User;
import shaded.com.getsentry.raven.event.interfaces.ExceptionInterface;
import shaded.ru.turikhay.util.windows.wmi.WMI;

public final class Bootstrap {
    public static final Raven SENTRY = new DefaultRavenFactory().createRavenInstance(new Dsn("https://3ece46580a3c4d4e900f41d20397d229:8fbceaeb066e4fcab40f9740d04eebab@sentry.ely.by/45"));
    private final InternalLauncher internal;
    private final BootBridge bootBridge;
    private final TargetConfig config;
    private IInterface ui;
    private final Path bootstrapJar;
    private Path targetJar;
    private Path targetLibFolder;
    private Path targetUpdateFile;
    private Path updateMetaFile;
    private String packageMode;
    private boolean ignoreUpdate;
    private boolean ignoreSelfUpdate;
    private List<String> restartCmd;
    private boolean switchToBeta;
    private static final JavaVersion SUPPORTED_JAVA_VERSION;

    static Bootstrap createBootstrap(String[] rawArgs) throws InterruptedException {
        Path bootstrapJar;
        SplitArgs args;
        Bootstrap.log("Starting bootstrap...");
        LocalBootstrapMeta localBootstrapMeta = LocalBootstrapMeta.getInstance();
        Path defaultFile = Objects.requireNonNull(LocalLauncher.getDefaultFileLocation(localBootstrapMeta.getShortBrand()), "defaultFileLocation");
        Path defaultLibFolder = defaultFile.getParent() == null ? Paths.get("lib", new String[0]) : defaultFile.getParent().resolve("lib");
        OptionParser bootstrapParser = new OptionParser();
        ArgumentAcceptingOptionSpec<Path> targetFileParser = bootstrapParser.accepts("targetJar", "points to the targetJar").withRequiredArg().withValuesConvertedBy(new PathValueConverter());
        ArgumentAcceptingOptionSpec<Path> targetLibFolderParser = bootstrapParser.accepts("targetLibFolder", "points to the library folder").withRequiredArg().withValuesConvertedBy(new PathValueConverter());
        ArgumentAcceptingOptionSpec<String> brandParser = bootstrapParser.accepts("brand", "defines brand name").withRequiredArg().ofType(String.class);
        OptionSpecBuilder forceUpdateParser = bootstrapParser.accepts("ignoreUpdate", "defines if bootstrap should ignore launcher update processes");
        OptionSpecBuilder ignoreSelfUpdateParser = bootstrapParser.accepts("ignoreSelfUpdate", "defines if bootstrap should ignore self update processes");
        OptionSpecBuilder forceHeadlessMode = bootstrapParser.accepts("headlessMode", "defines if bootstrap should run without UI");
        ArgumentAcceptingOptionSpec<String> packageMode = bootstrapParser.accepts("packageMode", "defines if bootstrap runs inside a package").withOptionalArg();
        ArgumentAcceptingOptionSpec<Path> targetUpdateFile = bootstrapParser.accepts("updateMetaFile", "points to update meta file").withRequiredArg().withValuesConvertedBy(new PathValueConverter());
        ArgumentAcceptingOptionSpec<String> restartExec = bootstrapParser.accepts("restartExec", "instructs the bootstrap to run this executable after self update").withRequiredArg().ofType(String.class);
        OptionSpecBuilder requireMinecraftAccount = bootstrapParser.accepts("requireMinecraftAccount", "require minecraft account to use any other account kinds");
        OptionParser launcherParser = new OptionParser();
        launcherParser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec<String> settings = launcherParser.accepts("settings").withRequiredArg();
        try {
            args = SplitArgs.splitArgs(rawArgs);
        }
        catch (RuntimeException rE) {
            throw new RuntimeException("couldn't split args: " + Arrays.toString(rawArgs), rE);
        }
        try {
            bootstrapJar = Paths.get(Bootstrap.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to determine bootstrap jar location", e);
        }
        RunningConditionsResult runningConditions = Bootstrap.checkRunningConditions(bootstrapJar);
        runningConditions.showErrorIfNeeded();
        CombinedOptionSet bootstrapParsed = new CombinedOptionSet(Bootstrap.parseJvmArgs(bootstrapParser), bootstrapParser.parse(args.getBootstrap()));
        boolean disallowBetaSwitch = false;
        if (bootstrapParsed.has(brandParser)) {
            String brand = bootstrapParsed.valueOf(brandParser);
            Bootstrap.log("Picked up brand from arguments: ", brand);
            localBootstrapMeta.setShortBrand(brand);
            disallowBetaSwitch = true;
        }
        Bootstrap.log("Short brand: ", localBootstrapMeta.getShortBrand());
        OptionSet launcherParsed = launcherParser.parse(args.getLauncher());
        Path configFile = launcherParsed.has(settings) ? Paths.get(launcherParsed.valueOf(settings), new String[0]) : TargetConfig.getDefaultConfigFilePath(localBootstrapMeta.getShortBrand());
        TargetConfig targetConfig = TargetConfig.readConfigFromFile(configFile);
        Bootstrap bootstrap = new Bootstrap(args.getLauncher(), bootstrapJar, targetConfig);
        if (disallowBetaSwitch) {
            bootstrap.bootBridge.addCapability("can_switch_to_beta_branch", Boolean.FALSE);
        }
        Bootstrap.log("Version: " + localBootstrapMeta.getVersion());
        bootstrap.setupUserInterface(bootstrapParsed.has(forceHeadlessMode));
        Path targetJar = bootstrapParsed.valueOf(targetFileParser);
        if (targetJar == null) {
            targetJar = Objects.requireNonNull(LocalLauncher.getDefaultFileLocation(localBootstrapMeta.getShortBrand()), "defaultFileLocation");
        }
        bootstrap.setTargetJar(targetJar);
        Bootstrap.log("Target jar:", bootstrap.getTargetJar());
        Path targetLibFolder = bootstrapParsed.valueOf(targetLibFolderParser);
        if (targetLibFolder == null) {
            targetLibFolder = bootstrap.getTargetJar().getParent() == null ? Paths.get("lib", new String[0]) : bootstrap.getTargetJar().getParent().resolve("lib");
        }
        bootstrap.setTargetLibFolder(targetLibFolder);
        Bootstrap.log("Target lib folder:", bootstrap.getTargetLibFolder());
        bootstrap.setUpdateMetaFile(bootstrapParsed.valueOf(targetUpdateFile));
        Bootstrap.log("Update meta file:", bootstrap.getUpdateMetaFile());
        bootstrap.setIgnoreUpdate(bootstrapParsed.has(forceUpdateParser));
        Bootstrap.log("Ignore launcher update:", bootstrap.getIgnoreUpdate());
        bootstrap.setIgnoreSelfUpdate(bootstrapParsed.has(ignoreSelfUpdateParser));
        Bootstrap.log("Ignore self update:", bootstrap.getIgnoreSelfUpdate());
        bootstrap.setPackageMode(bootstrapParsed.valueOf(packageMode));
        Bootstrap.log("Package mode:", bootstrap.isPackageMode() ? bootstrap.getPackageMode() : "false");
        bootstrap.bootBridge.addCapability("package_mode", bootstrap.isPackageMode() ? bootstrap.getPackageMode() : "");
        Bootstrap.log("Require Minecraft account:", bootstrapParsed.has(requireMinecraftAccount));
        bootstrap.bootBridge.addCapability("require_minecraft_account", bootstrapParsed.has(requireMinecraftAccount));
        if (bootstrapParsed.has(restartExec)) {
            bootstrap.setRestartCmd(Collections.singletonList(bootstrapParsed.valueOf(restartExec)));
            Bootstrap.log("Restart cmd on self update:", bootstrap.getRestartCmd());
        } else if ("dmg".equals(bootstrap.getPackageMode())) {
            String appPath = System.getProperty("jpackage.app-path");
            if (appPath == null) {
                Bootstrap.log("Current package mode is dmg, but jpackage.app-path is not set");
            } else {
                String expectedPathSuffix = "/Contents/MacOS/TL";
                if (appPath.endsWith("/Contents/MacOS/TL")) {
                    appPath = appPath.substring(0, appPath.length() - "/Contents/MacOS/TL".length());
                    bootstrap.setRestartCmd(Arrays.asList("sh", appPath + "/Contents/app/restart.sh", appPath));
                    Bootstrap.log("Picked up restart exec for jpackage:", bootstrap.getRestartCmd());
                    bootstrap.bootBridge.addCapability("dmg-app-path", appPath);
                } else {
                    Bootstrap.log("jpackage.app-path is not recognized:", appPath);
                    Bootstrap.log("Auto-restart will not be enabled");
                }
            }
        }
        if (bootstrap.isPackageMode()) {
            boolean ignoreUpdate = false;
            switch (bootstrap.getPackageMode()) {
                case "aur": {
                    ignoreUpdate = true;
                }
            }
            if (ignoreUpdate) {
                bootstrap.setIgnoreSelfUpdate(true);
                bootstrap.setIgnoreUpdate(true);
                Bootstrap.log("Package mode: Ignore self update set to", bootstrap.getIgnoreSelfUpdate());
                Bootstrap.log("Package mode: Ignore update set to", bootstrap.getIgnoreUpdate());
            }
        }
        return bootstrap;
    }

    private static OptionSet parseJvmArgs(OptionParser parser) {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        for (String key : parser.recognizedOptions().keySet()) {
            String value = System.getProperty("tlauncher.bootstrap." + key);
            if (value == null) continue;
            jvmArgs.add("--" + key);
            jvmArgs.add(value);
            Bootstrap.log("Found JVM arg: ", key, " ", value);
        }
        return parser.parse(jvmArgs.toArray(new String[0]));
    }

    public static void main(String[] args) {
        System.setOut(OutputRedirectBuffer.createRedirect(System.out));
        System.setErr(OutputRedirectBuffer.createRedirect(System.err));
        Bootstrap bootstrap = null;
        try {
            bootstrap = Bootstrap.createBootstrap(args);
            bootstrap.defTask().call();
        }
        catch (TaskInterruptedException interrupted) {
            Bootstrap.log("Default task was interrupted");
        }
        catch (InterruptedException interrupted) {
            Bootstrap.log("Interrupted");
        }
        catch (Exception e) {
            e.printStackTrace();
            Bootstrap.handleFatalError(bootstrap, e, true);
            System.exit(-1);
        }
        System.exit(0);
    }

    static void handleFatalError(Bootstrap bootstrap, Throwable e, boolean sendSentry) {
        BootBridge bridge;
        FatalExceptionType exceptionType = FatalExceptionType.getType(e);
        BootBridge bootBridge = bridge = bootstrap == null ? null : bootstrap.bootBridge;
        if (sendSentry) {
            EventBuilder b = new EventBuilder().withMessage("fatal error").withLevel(Event.Level.FATAL).withSentryInterface(new ExceptionInterface(e)).withTag("type", exceptionType.name());
            if (OS.WINDOWS.isCurrent()) {
                try {
                    b.withExtra("avList", WMI.getAVSoftwareList());
                }
                catch (Exception eAV) {
                    Bootstrap.log("Could not get AV list", eAV);
                }
            }
            if (bridge != null && bridge.getClient() != null) {
                SENTRY.getContext().setUser(new User(bridge.getClient().toString(), bridge.getClient().toString(), null, null));
            }
            SENTRY.sendEvent(b);
        }
        if (bootstrap != null) {
            bootstrap.getUserInterface().dispose();
        }
        UserInterface.showFatalError(exceptionType);
    }

    Bootstrap(String[] launcherArgs, Path bootstrapJar, TargetConfig config, Path targetJar, Path targetLibFolder) {
        this.bootstrapJar = bootstrapJar;
        this.config = config;
        String client = config.getClient();
        if (client != null) {
            SENTRY.getContext().setUser(new User(client, client, null, null));
        }
        SENTRY.addBuilderHelper(eventBuilder -> eventBuilder.withRelease(String.format(Locale.ROOT, "%d.%d.%d", LocalBootstrapMeta.getInstance().getVersion().getMajorVersion(), LocalBootstrapMeta.getInstance().getVersion().getMinorVersion(), LocalBootstrapMeta.getInstance().getVersion().getPatchVersion())).withEnvironment(LocalBootstrapMeta.getInstance().getShortBrand()));
        InternalLauncher internal = null;
        try {
            internal = new InternalLauncher();
        }
        catch (LauncherNotFoundException e) {
            Bootstrap.log("Internal launcher is not located in the classpath");
        }
        this.internal = internal;
        this.setTargetJar(targetJar);
        this.setTargetLibFolder(targetLibFolder);
        this.bootBridge = new BootBridge(U.getFormattedVersion(LocalBootstrapMeta.getInstance().getVersion()), launcherArgs);
        this.bootBridge.addCapability("jna");
        boolean isNotBeta = !"legacy_beta".equals(LocalBootstrapMeta.getInstance().getShortBrand());
        this.bootBridge.addCapability("can_switch_to_beta_branch", isNotBeta);
        if (config.isSwitchToBeta()) {
            if (isNotBeta) {
                Bootstrap.log("Configuration tells us to switch to beta branch");
                this.switchToBeta = true;
            } else {
                Bootstrap.log("Configuration tells us to switch to beta branch, but we're already on beta");
            }
        }
        this.bootBridge.addCapability("has_flatlaf");
        SwingUtilities.invokeLater(() -> {
            boolean preFlatLafConfiguration;
            FlatLafConfiguration flatLafConfig = FlatLafConfiguration.parseFromMap(this.config.isEmpty() || this.config.isFirstRun() ? FlatLafConfiguration.getDefaults() : this.config.asMap());
            String guiSystemLookAndFeel = this.config.get("gui.systemlookandfeel");
            boolean bl = preFlatLafConfiguration = !flatLafConfig.getState().isPresent() && guiSystemLookAndFeel != null;
            if (preFlatLafConfiguration) {
                Bootstrap.log("Detected pre-FlatLaf configuration");
            }
            if (preFlatLafConfiguration && "true".equals(guiSystemLookAndFeel) || flatLafConfig.getState().filter(s -> s == FlatLafConfiguration.State.SYSTEM).isPresent()) {
                Bootstrap.log("Using system L&F");
                UserInterface.setSystemLookAndFeel();
            } else if (preFlatLafConfiguration && "false".equals(guiSystemLookAndFeel)) {
                Bootstrap.log("Not setting L&F on pre-FlatLaf configuration because gui.systemlookandfeel == false");
            } else if (flatLafConfig.isEnabled()) {
                Bootstrap.log("Using FlatLaf configuration");
                FlatLaf.initialize(flatLafConfig);
            } else {
                Bootstrap.log("Not setting L&F because FlatLaf is not enabled");
            }
            this.bootBridge.addCapability("set_laf");
        });
    }

    public Bootstrap(String[] launcherArgs, Path bootstrapJar, TargetConfig targetConfig) {
        this(launcherArgs, bootstrapJar, targetConfig, null, null);
    }

    public void setupUserInterface(boolean forceHeadlessMode) throws InterruptedException {
        if (this.ui != null) {
            return;
        }
        Bootstrap.log("Setting up user interface");
        if (forceHeadlessMode) {
            Bootstrap.log("Forcing headless mode");
        } else {
            Bootstrap.log("Trying to load user interface");
            try {
                this.ui = UserInterface.createInterface();
                Bootstrap.log("UI loaded");
                return;
            }
            catch (RuntimeException rE) {
                Bootstrap.log("User interface is not loaded:", rE);
            }
        }
        this.ui = new HeadlessInterface();
        Bootstrap.log("Headless mode loaded");
    }

    IInterface getUserInterface() {
        return this.ui;
    }

    public Path getTargetJar() {
        return this.targetJar;
    }

    private void setTargetJar(Path file) {
        this.targetJar = file;
    }

    public Path getTargetLibFolder() {
        return this.targetLibFolder;
    }

    private void setTargetLibFolder(Path targetLibFolder) {
        this.targetLibFolder = targetLibFolder;
    }

    public boolean getIgnoreUpdate() {
        return this.ignoreUpdate;
    }

    private void setIgnoreUpdate(boolean ignore) {
        this.ignoreUpdate = ignore;
    }

    public boolean getIgnoreSelfUpdate() {
        return this.ignoreSelfUpdate;
    }

    public void setIgnoreSelfUpdate(boolean ignoreSelfUpdate) {
        this.ignoreSelfUpdate = ignoreSelfUpdate;
    }

    public String getPackageMode() {
        return this.packageMode;
    }

    public boolean isPackageMode() {
        return this.packageMode != null;
    }

    public void setPackageMode(String packageMode) {
        this.packageMode = packageMode;
    }

    public List<String> getRestartCmd() {
        return this.restartCmd;
    }

    public void setRestartCmd(List<String> restartCmd) {
        this.restartCmd = restartCmd;
    }

    public Path getTargetUpdateFile() {
        return this.targetUpdateFile;
    }

    private void setTargetUpdateFile(Path targetUpdateFile) {
        this.targetUpdateFile = targetUpdateFile;
    }

    public Path getUpdateMetaFile() {
        return this.updateMetaFile;
    }

    private void setUpdateMetaFile(Path updateMetaFile) {
        this.updateMetaFile = updateMetaFile;
    }

    BootBridge getBootBridge() {
        return this.bootBridge;
    }

    DownloadEntry getBootstrapUpdate(UpdateMeta updateMeta) {
        String localBootstrapChecksum;
        RemoteBootstrapMeta remoteMeta = Objects.requireNonNull(updateMeta, "updateMeta").getBootstrap();
        if (remoteMeta == null) {
            Bootstrap.log("RemoteBootstrap meta is not available");
            return null;
        }
        Bootstrap.log("RemoteBootstrap meta", remoteMeta);
        Objects.requireNonNull(remoteMeta, "RemoteBootstrap meta");
        Objects.requireNonNull(remoteMeta.getDownload(), "RemoteBootstrap download URL");
        Bootstrap.log("Local bootstrap version: " + LocalBootstrapMeta.getInstance().getVersion());
        Bootstrap.log("Remote bootstrap version: " + remoteMeta.getVersion());
        if (LocalBootstrapMeta.getInstance().getVersion().greaterThan(remoteMeta.getVersion())) {
            Bootstrap.log("Local bootstrap version is newer than remote one");
            return null;
        }
        try {
            localBootstrapChecksum = Sha256Sign.calc(this.bootstrapJar);
        }
        catch (Exception e) {
            Bootstrap.log("Could not get local bootstrap checksum", e);
            return null;
        }
        Bootstrap.log("Remote bootstrap checksum of selected package: " + remoteMeta.getDownload());
        Bootstrap.log("Local bootstrap checksum: " + localBootstrapChecksum);
        Bootstrap.log("Remote bootstrap checksum: " + remoteMeta.getDownload().getChecksum());
        if (localBootstrapChecksum.equalsIgnoreCase(remoteMeta.getDownload().getChecksum())) {
            return null;
        }
        return remoteMeta.getDownload();
    }

    TaskList downloadLibraries(LocalLauncherMeta localLauncherMeta) {
        TaskList taskList = new TaskList("downloadLibraries", 4);
        Path libDir = this.getTargetLibFolder();
        for (Library library : localLauncherMeta.getLibraries()) {
            taskList.submit(library.download(libDir));
        }
        return taskList;
    }

    Task<LocalLauncherTask> prepareLauncher(final UpdateMeta updateMeta) {
        return new Task<LocalLauncherTask>("prepareLauncher"){

            @Override
            protected LocalLauncherTask execute() throws Exception {
                RemoteLauncher remoteLauncher = updateMeta == null ? null : new RemoteLauncher(updateMeta.getLauncher(Bootstrap.this.switchToBeta));
                this.log("Remote launcher: " + remoteLauncher);
                boolean ignoreUpdate = Bootstrap.this.getIgnoreUpdate();
                LocalLauncherTask localLauncherTask = (LocalLauncherTask)this.bindTo(Bootstrap.this.getLocalLauncher(remoteLauncher), 0.0, ignoreUpdate ? 1.0 : 0.25);
                LocalLauncher localLauncher = localLauncherTask.getLauncher();
                LocalLauncherMeta localLauncherMeta = localLauncher.getMeta();
                this.log("Local launcher: " + localLauncher);
                Bootstrap.this.printVersion(localLauncherMeta);
                if (!ignoreUpdate) {
                    this.log("Downloading libraries...");
                    this.bindTo(Bootstrap.this.downloadLibraries(localLauncherMeta), 0.25, 1.0);
                }
                return localLauncherTask;
            }
        };
    }

    Task<Void> startLauncher(final LocalLauncher localLauncher) {
        return new Task<Void>("startLauncher"){

            @Override
            protected Void execute() throws Exception {
                this.log("Starting launcher...");
                Bootstrap.this.bootBridge.addListener(new BootListenerAdapter(){

                    @Override
                    public void onBootStateChanged(String stepName, double percentage) {
                        this.updateProgress(percentage);
                    }
                });
                return this.bindTo(ClassLoaderStarter.start(localLauncher, Bootstrap.this.bootBridge), 0.0, 1.0);
            }
        };
    }

    private Task<Void> defTask() {
        return new Task<Void>("defTask"){
            {
                if (Bootstrap.this.ui != null) {
                    Bootstrap.this.ui.bindToTask(this);
                }
            }

            @Override
            protected Void execute() throws Exception {
                DownloadEntry downloadEntry;
                UpdateMeta updateMeta;
                Bootstrap.this.printVersion(null);
                Bootstrap.this.lowerRequirementsIfNeeded();
                if (Bootstrap.this.updateMetaFile != null) {
                    Compressor.init();
                    try (SignedStream signedStream = new SignedStream(Files.newInputStream(Bootstrap.this.updateMetaFile, new OpenOption[0]));){
                        updateMeta = UpdateMeta.fetchFrom(Compressor.uncompressMarked(signedStream, false), LocalBootstrapMeta.getInstance().getShortBrand());
                        signedStream.validateSignature();
                    }
                }
                try {
                    updateMeta = this.bindTo(UpdateMeta.fetchFor(LocalBootstrapMeta.getInstance().getShortBrand(), Bootstrap.this.createInterrupter()), 0.0, 0.25);
                }
                catch (UpdateMeta.UpdateMetaFetchFailed e) {
                    this.log(e);
                    updateMeta = null;
                }
                if (updateMeta != null && (downloadEntry = Bootstrap.this.getBootstrapUpdate(updateMeta)) != null) {
                    if (Bootstrap.this.getIgnoreSelfUpdate()) {
                        this.log("Bootstrap self update ignored:", updateMeta.getBootstrap() == null ? null : updateMeta.getBootstrap().getVersion());
                    } else {
                        Updater updater = new Updater("bootstrapUpdate", Bootstrap.this.bootstrapJar, downloadEntry);
                        if (Bootstrap.this.getRestartCmd() != null) {
                            updater.restartOnFinish(Bootstrap.this.getRestartCmd());
                        }
                        this.bindTo(updater, 0.25, 1.0);
                        return null;
                    }
                }
                LocalLauncherTask localLauncherTask = this.bindTo(Bootstrap.this.prepareLauncher(updateMeta), 0.25, 0.75);
                LocalLauncher localLauncher = localLauncherTask.getLauncher();
                if (updateMeta != null) {
                    Bootstrap.this.bootBridge.setOptions(updateMeta.getOptions());
                }
                if (localLauncherTask.isUpdated() && updateMeta != null) {
                    Bootstrap.this.addUpdateMessage(updateMeta.getLauncher(Bootstrap.this.switchToBeta));
                }
                this.bindTo(Bootstrap.this.startLauncher(localLauncher), 0.75, 1.0);
                this.checkInterrupted();
                this.log("Idle state: Waiting for launcher the close");
                Bootstrap.this.bootBridge.waitUntilClose();
                return null;
            }
        };
    }

    private void lowerRequirementsIfNeeded() throws Exception {
        Path targetJarParent;
        FileStat bootstrapStat = Bootstrap.fileStat(this.bootstrapJar);
        if (!bootstrapStat.writeable && !this.getIgnoreSelfUpdate()) {
            Bootstrap.log("Bootstrap jar not writeable, disable self updating");
            this.setIgnoreSelfUpdate(true);
        }
        if ((targetJarParent = this.getTargetJar().getParent()) != null) {
            Files.createDirectories(targetJarParent, new FileAttribute[0]);
        }
        FileStat launcherStat = Bootstrap.fileStat(this.getTargetJar());
        if (launcherStat.exists && !launcherStat.writeable && !this.getIgnoreUpdate()) {
            Bootstrap.log("Launcher jar not writeable, disable updating");
            this.setIgnoreUpdate(true);
        }
        Files.createDirectories(this.getTargetLibFolder(), new FileAttribute[0]);
        FileStat libStat = Bootstrap.fileStat(this.getTargetLibFolder());
        if (!libStat.writeable && !this.getIgnoreUpdate()) {
            Bootstrap.log("Libs directory not writeable, disable updating");
            this.setIgnoreUpdate(true);
        }
    }

    private UpdateMeta.ConnectionInterrupter createInterrupter() {
        if (this.ui instanceof UserInterface) {
            return ((UserInterface)this.ui).createInterrupter();
        }
        return null;
    }

    private void addUpdateMessage(RemoteLauncherMeta remoteLauncherMeta) {
        Map<String, String> description = remoteLauncherMeta.getDescription();
        if (description == null) {
            return;
        }
        String updateTitle = UserInterface.getLString("update.launcher.title", "Launcher was updated");
        for (Map.Entry<String, String> entry : description.entrySet()) {
            this.bootBridge.addMessage(entry.getKey(), updateTitle, entry.getValue());
        }
    }

    private void printVersion(LocalLauncherMeta localLauncherMeta) {
        HeadlessInterface.printVersion(LocalBootstrapMeta.getInstance().getVersion().toString(), localLauncherMeta == null ? null : localLauncherMeta.getVersion().toString());
    }

    private Task<LocalLauncherTask> getLocalLauncher(final RemoteLauncher remote) {
        return new Task<LocalLauncherTask>("getLocalLauncher"){

            @Override
            protected LocalLauncherTask execute() throws Exception {
                LocalLauncher fromRemote;
                Path file;
                LocalLauncher local;
                this.updateProgress(0.0);
                this.log("Getting local launcher...");
                RemoteLauncherMeta remoteLauncherMeta = remote == null ? null : Objects.requireNonNull(remote.getMeta(), "RemoteLauncherMeta");
                try {
                    local = new LocalLauncher(Bootstrap.this.getTargetJar(), Bootstrap.this.getTargetLibFolder());
                }
                catch (LauncherNotFoundException lnfE) {
                    this.log("Could not find local launcher:", lnfE);
                    if (Bootstrap.this.internal == null) {
                        local = null;
                    }
                    this.log("... replacing it with internal one:", Bootstrap.this.internal);
                    local = this.bindTo(Bootstrap.this.internal.toLocalLauncher(Bootstrap.this.getTargetJar(), Bootstrap.this.getTargetLibFolder()), 0.0, 0.1);
                }
                Path path = file = local != null ? local.getFile() : Bootstrap.this.getTargetJar();
                if (local != null) {
                    LocalLauncherMeta localLauncherMeta;
                    if (remote == null) {
                        this.log("We have local launcher, but have no remote.");
                        return new LocalLauncherTask(local);
                    }
                    try {
                        localLauncherMeta = Objects.requireNonNull(local.getMeta(), "LocalLauncherMeta");
                    }
                    catch (IOException ioE) {
                        this.log("Could not get local launcher meta:", ioE);
                        localLauncherMeta = null;
                    }
                    this.updateProgress(0.2);
                    boolean doUpdate = false;
                    if (localLauncherMeta != null) {
                        Objects.requireNonNull(localLauncherMeta.getShortBrand(), "LocalLauncher shortBrand");
                        Objects.requireNonNull(localLauncherMeta.getBrand(), "LocalLauncher brand");
                        Objects.requireNonNull(localLauncherMeta.getMainClass(), "LocalLauncher mainClass");
                        if (!localLauncherMeta.getVersion().equals(remote.getMeta().getVersion())) {
                            this.log("Local version doesn't match remote");
                            if (Bootstrap.this.getIgnoreUpdate()) {
                                this.log("... nevermind");
                            } else {
                                doUpdate = true;
                            }
                        } else if (!Bootstrap.this.getIgnoreUpdate()) {
                            String localLauncherHash = Sha256Sign.calc(local.getFile());
                            this.log("Local SHA256: " + localLauncherHash);
                            this.log("Remote SHA256: " + remoteLauncherMeta.getChecksum());
                            if (!localLauncherHash.equalsIgnoreCase(remoteLauncherMeta.getChecksum())) {
                                this.log("... local SHA256 checksum is not the same as remote");
                                doUpdate = true;
                            } else {
                                this.log("All done, local launcher is up to date.");
                            }
                        }
                        if (!doUpdate) {
                            return new LocalLauncherTask(local);
                        }
                    }
                    this.updateProgress(0.5);
                }
                if (remote == null) {
                    throw new LauncherNotFoundException("could not retrieve any launcher");
                }
                try {
                    fromRemote = this.bindTo(remote.toLocalLauncher(file, Bootstrap.this.getTargetLibFolder()), 0.5, 1.0);
                }
                catch (IOException ioE) {
                    if (local == null) {
                        throw ioE;
                    }
                    SENTRY.sendEvent(new EventBuilder().withLevel(Event.Level.ERROR).withMessage("couldn't download remote launcher").withSentryInterface(new ExceptionInterface(ioE)));
                    return new LocalLauncherTask(local);
                }
                return new LocalLauncherTask(fromRemote, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RunningConditionsResult checkRunningConditions(Path bootstrapJar) {
        RunningConditionsResult result = new RunningConditionsResult();
        JavaVersion current = JavaVersion.getCurrent();
        if (current == JavaVersion.UNKNOWN) {
            SENTRY.sendEvent(new EventBuilder().withLevel(Event.Level.WARNING).withMessage("unknown java version: " + System.getProperty("java.version")));
        } else if (current.compareTo(SUPPORTED_JAVA_VERSION) < 0) {
            SENTRY.sendEvent(new EventBuilder().withLevel(Event.Level.ERROR).withMessage("old java version").withExtra("ssl_fix", FixSSL.isFixed()));
            result.javaVersionUnsupported = true;
            return result;
        }
        if (bootstrapJar.toAbsolutePath().toString().contains("!" + File.separatorChar)) {
            result.brokenPath = bootstrapJar;
        }
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile("bootstrap", null, new FileAttribute[0]);
            FileStat tempFileStat = Bootstrap.fileStat(tempFile);
            if (!tempFileStat.writeable) {
                result.tempDirUnwriteable = true;
            }
            if (!tempFileStat.enoughSpace) {
                result.tempDirNotEnoughSpace = true;
            }
        }
        catch (IOException e) {
            result.tempDirUnwriteable = true;
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static FileStat fileStat(Path path) {
        boolean readable = Files.isReadable(path);
        boolean writeable = Files.isWritable(path);
        boolean enoughSpace = U.queryFreeSpace(path) > 65536L;
        return new FileStat(Files.exists(path, new LinkOption[0]), readable, writeable, enoughSpace);
    }

    private static void log(Object ... o) {
        U.log("[Bootstrap]", o);
    }

    static {
        SENTRY.addBuilderHelper(eventBuilder -> eventBuilder.withServerName(OS.CURRENT.name()).withTag("java", JavaVersion.getCurrent() == JavaVersion.UNKNOWN ? "unknown" : String.valueOf(JavaVersion.getCurrent().getMajor())).withTag("java_version", System.getProperty("java.version")).withTag("os", System.getProperty("os.name") + " " + System.getProperty("os.version")).withTag("os_arch", System.getProperty("os.arch")));
        FixSSL.addLetsEncryptCertSupportIfNeeded();
        SUPPORTED_JAVA_VERSION = JavaVersion.create(1, 8, 0, 45);
    }

    private static class RunningConditionsResult {
        public boolean javaVersionUnsupported = false;
        public Path brokenPath = null;
        public boolean tempDirUnwriteable = false;
        public boolean tempDirNotEnoughSpace = false;

        private RunningConditionsResult() {
        }

        public String formatMessage() {
            StringBuilder message = new StringBuilder();
            if (this.javaVersionUnsupported) {
                RunningConditionsResult.appendLine(message, "Your Java version is not supported. Please install at least " + SUPPORTED_JAVA_VERSION.getVersion() + " from Java.com");
                RunningConditionsResult.appendLine(message, "\u0412\u0430\u0448\u0430 \u0432\u0435\u0440\u0441\u0438\u044f Java \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c " + SUPPORTED_JAVA_VERSION.getVersion() + " \u0441 \u0441\u0430\u0439\u0442\u0430 Java.com");
            }
            if (this.brokenPath != null) {
                RunningConditionsResult.appendLine(message, "Please do not run (any) Java application which path contains folder name that ends with \u00ab!\u00bb");
                RunningConditionsResult.appendLine(message, "\u041d\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0439\u0442\u0435 Java-\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f\u0445, \u0447\u0435\u0439 \u043f\u0443\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u00ab!\u00bb. \u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u0435 Legacy Launcher \u0432 \u0434\u0440\u0443\u0433\u0443\u044e \u043f\u0430\u043f\u043a\u0443.");
            }
            if (this.tempDirUnwriteable) {
                RunningConditionsResult.appendLine(message, "Could not access temporary folder. Please check your hard drive.");
                RunningConditionsResult.appendLine(message, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0434\u0438\u0441\u043a \u043d\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043e\u0448\u0438\u0431\u043e\u043a.");
            }
            if (this.tempDirNotEnoughSpace) {
                RunningConditionsResult.appendLine(message, "Insufficient disk space on partition storing temporary folder.");
                RunningConditionsResult.appendLine(message, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043c\u0435\u0441\u0442\u0430 \u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u043c \u0434\u0438\u0441\u043a\u0435. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u0435 \u043c\u0435\u0441\u0442\u043e \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.");
            }
            return message.toString();
        }

        private static void appendLine(StringBuilder buffer, String line) {
            if (buffer.length() != 0) {
                buffer.append("\n");
            }
            buffer.append(line);
        }

        public void showErrorIfNeeded() {
            String message = this.formatMessage();
            if (!message.isEmpty()) {
                Bootstrap.log(new Object[]{"Preconditions failed:", message});
                UserInterface.showError(message, this.brokenPath);
                throw new RuntimeException("precodintions failed");
            }
        }
    }

    private static class FileStat {
        public final boolean exists;
        public final boolean readable;
        public final boolean writeable;
        public final boolean enoughSpace;

        private FileStat(boolean exists, boolean readable, boolean writeable, boolean enoughSpace) {
            this.exists = exists;
            this.readable = readable;
            this.writeable = writeable;
            this.enoughSpace = enoughSpace;
        }
    }
}

