/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freedesktop.dbus.bin.DBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfigBuilder;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.connections.transports.TransportConnection;
import org.freedesktop.dbus.exceptions.AuthenticationException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.SocketClosedException;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDBusDaemon
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedDBusDaemon.class);
    private final BusAddress address;
    private DBusDaemon daemon;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean connectionReady = new AtomicBoolean(false);
    private TransportBuilder.SaslAuthMode saslAuthMode;
    private String unixSocketFileOwner;
    private String unixSocketFileGroup;
    private PosixFilePermission[] unixSocketFilePermissions;

    public EmbeddedDBusDaemon(BusAddress _address) {
        this.address = BusAddress.of(Objects.requireNonNull(_address, "Address required"));
    }

    public EmbeddedDBusDaemon(String _address) throws DBusException {
        this(BusAddress.of(_address));
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed.set(true);
        this.connectionReady.set(false);
        if (this.daemon != null) {
            this.daemon.close();
            this.daemon = null;
        }
    }

    public void startInForeground() {
        block2: {
            try {
                this.startListening();
            }
            catch (IOException | DBusException _ex) {
                if (this.closed.get()) break block2;
                throw new RuntimeException(_ex);
            }
        }
    }

    public void startInBackground() {
        Thread thread = new Thread(this::startInForeground);
        String threadName = this.address.toString().replaceAll("^([^,]+),.+", "$1");
        thread.setName("EmbeddedDBusDaemon-" + threadName);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((th, ex) -> LOGGER.error("Got uncaught exception", ex));
        thread.start();
    }

    public void startInBackgroundAndWait(long _maxWaitMillis) {
        this.startInBackground();
        Util.waitFor("EmbeddedDbusDaemon", this::isRunning, _maxWaitMillis, 100L);
    }

    public synchronized boolean isRunning() {
        return this.connectionReady.get() && this.daemon != null && this.daemon.isRunning();
    }

    public TransportBuilder.SaslAuthMode getSaslAuthMode() {
        return this.saslAuthMode;
    }

    public void setSaslAuthMode(TransportBuilder.SaslAuthMode _saslAuthMode) {
        this.saslAuthMode = _saslAuthMode;
    }

    public void setUnixSocketOwner(String _owner) {
        this.unixSocketFileOwner = _owner;
    }

    public void setUnixSocketGroup(String _group) {
        this.unixSocketFileGroup = _group;
    }

    public void setUnixSocketPermissions(PosixFilePermission ... _permissions) {
        this.unixSocketFilePermissions = _permissions;
    }

    private synchronized void setDaemonAndStart(AbstractTransport _transport) {
        this.daemon = new DBusDaemon(_transport);
        this.daemon.start();
    }

    private void startListening() throws IOException, DBusException {
        if (!TransportBuilder.getRegisteredBusTypes().contains(this.address.getBusType())) {
            throw new IllegalArgumentException("Unknown or unsupported address type: " + this.address.getType());
        }
        LOGGER.debug("About to initialize transport on: {}", (Object)this.address);
        try (AbstractTransport transport = ((TransportBuilder)((TransportConfigBuilder)((TransportConfigBuilder)((TransportConfigBuilder)TransportBuilder.create(this.address).configure().withUnixSocketFileOwner(this.unixSocketFileOwner).withUnixSocketFileGroup(this.unixSocketFileGroup)).withUnixSocketFilePermissions(this.unixSocketFilePermissions)).withAutoConnect(false)).configureSasl().withAuthMode(this.getSaslAuthMode()).back().back()).build();){
            this.setDaemonAndStart(transport);
            do {
                try {
                    LOGGER.debug("Begin listening to: {}", (Object)transport);
                    this.connectionReady.set(true);
                    TransportConnection s = transport.listen();
                    this.daemon.addSock(s);
                }
                catch (AuthenticationException _ex) {
                    LOGGER.error("Authentication failed", _ex);
                }
                catch (SocketClosedException _ex) {
                    LOGGER.debug("Connection closed", _ex);
                }
            } while (this.daemon.isRunning());
        }
    }
}

