/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.marshaller.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.sentry.event.Breadcrumb;
import io.sentry.event.Event;
import io.sentry.event.Sdk;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.marshaller.Marshaller;
import io.sentry.marshaller.json.InterfaceBinding;
import io.sentry.marshaller.json.SentryJsonGenerator;
import io.sentry.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMarshaller
implements Marshaller {
    public static final String EVENT_ID = "event_id";
    public static final String MESSAGE = "message";
    public static final String TIMESTAMP = "timestamp";
    public static final String LEVEL = "level";
    public static final String LOGGER = "logger";
    public static final String PLATFORM = "platform";
    public static final String CULPRIT = "culprit";
    public static final String TRANSACTION = "transaction";
    public static final String SDK = "sdk";
    public static final String TAGS = "tags";
    public static final String BREADCRUMBS = "breadcrumbs";
    public static final String CONTEXTS = "contexts";
    public static final String SERVER_NAME = "server_name";
    public static final String RELEASE = "release";
    public static final String DIST = "dist";
    public static final String ENVIRONMENT = "environment";
    public static final String FINGERPRINT = "fingerprint";
    public static final String MODULES = "modules";
    public static final String EXTRA = "extra";
    public static final String CHECKSUM = "checksum";
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 1000;
    private static final ThreadLocal<DateFormat> ISO_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JsonMarshaller.class);
    private final JsonFactory jsonFactory = new JsonFactory();
    private final Map<Class<? extends SentryInterface>, InterfaceBinding<?>> interfaceBindings = new HashMap();
    private boolean compression = true;
    private final int maxMessageLength;

    public JsonMarshaller() {
        this(1000);
    }

    public JsonMarshaller(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshall(Event event, OutputStream destination) throws IOException {
        destination = new Marshaller.UncloseableOutputStream(destination);
        if (this.compression) {
            destination = new GZIPOutputStream(destination);
        }
        try (JsonGenerator generator = this.createJsonGenerator(destination);){
            this.writeContent(generator, event);
        }
        catch (IOException e) {
            logger.error("An exception occurred while serialising the event.", (Throwable)e);
        }
        finally {
            try {
                destination.close();
            }
            catch (IOException e) {
                logger.error("An exception occurred while serialising the event.", (Throwable)e);
            }
        }
    }

    protected JsonGenerator createJsonGenerator(OutputStream destination) throws IOException {
        return new SentryJsonGenerator(this.jsonFactory.createGenerator(destination));
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getContentEncoding() {
        if (this.isCompressed()) {
            return "gzip";
        }
        return null;
    }

    private void writeContent(JsonGenerator generator, Event event) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(EVENT_ID, this.formatId(event.getId()));
        generator.writeStringField(MESSAGE, Util.trimString(event.getMessage(), this.maxMessageLength));
        generator.writeStringField(TIMESTAMP, ISO_FORMAT.get().format(event.getTimestamp()));
        generator.writeStringField(LEVEL, this.formatLevel(event.getLevel()));
        generator.writeStringField(LOGGER, event.getLogger());
        generator.writeStringField(PLATFORM, event.getPlatform());
        generator.writeStringField(CULPRIT, event.getCulprit());
        generator.writeStringField(TRANSACTION, event.getTransaction());
        this.writeSdk(generator, event.getSdk());
        this.writeTags(generator, event.getTags());
        this.writeBreadcumbs(generator, event.getBreadcrumbs());
        this.writeContexts(generator, event.getContexts());
        generator.writeStringField(SERVER_NAME, event.getServerName());
        generator.writeStringField(RELEASE, event.getRelease());
        generator.writeStringField(DIST, event.getDist());
        generator.writeStringField(ENVIRONMENT, event.getEnvironment());
        this.writeExtras(generator, event.getExtra());
        this.writeCollection(generator, FINGERPRINT, event.getFingerprint());
        generator.writeStringField(CHECKSUM, event.getChecksum());
        this.writeInterfaces(generator, event.getSentryInterfaces());
        generator.writeEndObject();
    }

    private void writeInterfaces(JsonGenerator generator, Map<String, SentryInterface> sentryInterfaces) throws IOException {
        for (Map.Entry<String, SentryInterface> interfaceEntry : sentryInterfaces.entrySet()) {
            SentryInterface sentryInterface = interfaceEntry.getValue();
            if (this.interfaceBindings.containsKey(sentryInterface.getClass())) {
                generator.writeFieldName(interfaceEntry.getKey());
                this.getInterfaceBinding(sentryInterface).writeInterface(generator, interfaceEntry.getValue());
                continue;
            }
            logger.error("Couldn't parse the content of '{}' provided in {}.", (Object)interfaceEntry.getKey(), (Object)sentryInterface);
        }
    }

    private <T extends SentryInterface> InterfaceBinding<? super T> getInterfaceBinding(T sentryInterface) {
        return this.interfaceBindings.get(sentryInterface.getClass());
    }

    private void writeExtras(JsonGenerator generator, Map<String, Object> extras) throws IOException {
        generator.writeObjectFieldStart(EXTRA);
        for (Map.Entry<String, Object> extra : extras.entrySet()) {
            generator.writeFieldName(extra.getKey());
            generator.writeObject(extra.getValue());
        }
        generator.writeEndObject();
    }

    private void writeCollection(JsonGenerator generator, String name, Collection<String> value) throws IOException {
        if (value != null && !value.isEmpty()) {
            generator.writeArrayFieldStart(name);
            for (String element : value) {
                generator.writeString(element);
            }
            generator.writeEndArray();
        }
    }

    private void writeSdk(JsonGenerator generator, Sdk sdk) throws IOException {
        generator.writeObjectFieldStart(SDK);
        generator.writeStringField("name", sdk.getName());
        generator.writeStringField("version", sdk.getVersion());
        if (sdk.getIntegrations() != null && !sdk.getIntegrations().isEmpty()) {
            generator.writeArrayFieldStart("integrations");
            for (String integration : sdk.getIntegrations()) {
                generator.writeString(integration);
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    private void writeTags(JsonGenerator generator, Map<String, String> tags) throws IOException {
        generator.writeObjectFieldStart(TAGS);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            generator.writeStringField(tag.getKey(), tag.getValue());
        }
        generator.writeEndObject();
    }

    private void writeBreadcumbs(JsonGenerator generator, List<Breadcrumb> breadcrumbs) throws IOException {
        if (breadcrumbs.isEmpty()) {
            return;
        }
        generator.writeObjectFieldStart(BREADCRUMBS);
        generator.writeArrayFieldStart("values");
        for (Breadcrumb breadcrumb : breadcrumbs) {
            generator.writeStartObject();
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(tz);
            generator.writeStringField(TIMESTAMP, df.format(breadcrumb.getTimestamp()));
            if (breadcrumb.getType() != null) {
                generator.writeStringField("type", breadcrumb.getType().getValue());
            }
            if (breadcrumb.getLevel() != null) {
                generator.writeStringField(LEVEL, breadcrumb.getLevel().getValue());
            }
            if (breadcrumb.getMessage() != null) {
                generator.writeStringField(MESSAGE, breadcrumb.getMessage());
            }
            if (breadcrumb.getCategory() != null) {
                generator.writeStringField("category", breadcrumb.getCategory());
            }
            if (breadcrumb.getData() != null && !breadcrumb.getData().isEmpty()) {
                generator.writeObjectFieldStart("data");
                for (Map.Entry<String, String> entry : breadcrumb.getData().entrySet()) {
                    generator.writeStringField(entry.getKey(), entry.getValue());
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void writeContexts(JsonGenerator generator, Map<String, Map<String, Object>> contexts) throws IOException {
        if (contexts.isEmpty()) {
            return;
        }
        generator.writeObjectFieldStart(CONTEXTS);
        for (Map.Entry<String, Map<String, Object>> contextEntry : contexts.entrySet()) {
            generator.writeObjectFieldStart(contextEntry.getKey());
            for (Map.Entry<String, Object> innerContextEntry : contextEntry.getValue().entrySet()) {
                generator.writeObjectField(innerContextEntry.getKey(), innerContextEntry.getValue());
            }
            generator.writeEndObject();
        }
        generator.writeEndObject();
    }

    private String formatId(UUID id) {
        return id.toString().replaceAll("-", "");
    }

    private String formatLevel(Event.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case DEBUG: {
                return "debug";
            }
            case FATAL: {
                return "fatal";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
        }
        logger.error("The level '{}' isn't supported, this should NEVER happen, contact Sentry developers", (Object)level.name());
        return null;
    }

    public <T extends SentryInterface, F extends T> void addInterfaceBinding(Class<F> sentryInterfaceClass, InterfaceBinding<T> binding) {
        this.interfaceBindings.put(sentryInterfaceClass, binding);
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public boolean isCompressed() {
        return this.compression;
    }
}

