/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config.provider;

import io.sentry.config.provider.ConfigurationProvider;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiConfigurationProvider
implements ConfigurationProvider {
    public static final String DEFAULT_JNDI_PREFIX = "java:comp/env/sentry/";
    private static final Logger logger = LoggerFactory.getLogger(JndiConfigurationProvider.class);
    private final String prefix;
    private final JndiContextProvider contextProvider;

    public JndiConfigurationProvider() {
        this(DEFAULT_JNDI_PREFIX, new JndiContextProvider(){

            @Override
            public Context getContext() throws NamingException {
                return new InitialContext();
            }
        });
    }

    public JndiConfigurationProvider(String jndiNamePrefix, JndiContextProvider contextProvider) {
        this.prefix = jndiNamePrefix;
        this.contextProvider = contextProvider;
    }

    @Override
    public String getProperty(String key) {
        String value = null;
        try {
            Context ctx = this.contextProvider.getContext();
            value = (String)ctx.lookup(this.prefix + key);
        }
        catch (NoInitialContextException e) {
            logger.trace("JNDI not configured for Sentry (NoInitialContextEx)");
        }
        catch (NamingException e) {
            logger.trace("No " + this.prefix + key + " in JNDI");
        }
        catch (RuntimeException e) {
            logger.warn("Odd RuntimeException while testing for JNDI", (Throwable)e);
        }
        return value;
    }

    public static interface JndiContextProvider {
        public Context getContext() throws NamingException;
    }
}

