/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.config.Lookup;
import io.sentry.config.ResourceLoader;
import io.sentry.dsn.Dsn;
import io.sentry.util.Nullable;
import io.sentry.util.Objects;
import io.sentry.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SentryOptions {
    private static final Logger logger = LoggerFactory.getLogger(SentryOptions.class);
    private Lookup lookup;
    private SentryClientFactory sentryClientFactory;
    private String dsn;
    @Deprecated
    private ResourceLoader resourceLoader;

    public SentryOptions(Lookup lookup, @Nullable String dsn, @Nullable SentryClientFactory sentryClientFactory) {
        this.lookup = Objects.requireNonNull(lookup, "lookup");
        this.dsn = SentryOptions.resolveDsn(lookup, dsn);
        this.sentryClientFactory = sentryClientFactory == null ? SentryClientFactory.instantiateFrom(this.lookup, this.dsn) : sentryClientFactory;
        this.resourceLoader = null;
        if (this.sentryClientFactory == null) {
            logger.error("Failed to find a Sentry client factory in the provided configuration. Will continue with a dummy implementation that will send no data.");
            this.sentryClientFactory = new InvalidSentryClientFactory();
        }
    }

    public static SentryOptions from(Lookup lookup) {
        return SentryOptions.from(lookup, null, null);
    }

    public static SentryOptions from(Lookup lookup, @Nullable String dsn) {
        return SentryOptions.from(lookup, dsn, null);
    }

    public static SentryOptions from(Lookup lookup, @Nullable String dsn, @Nullable SentryClientFactory factory) {
        return new SentryOptions(lookup, dsn, factory);
    }

    public static SentryOptions defaults() {
        return SentryOptions.defaults(null);
    }

    public static SentryOptions defaults(@Nullable String dsn) {
        return SentryOptions.from(Lookup.getDefault(), dsn, null);
    }

    public SentryClientFactory getSentryClientFactory() {
        return this.sentryClientFactory;
    }

    public void setSentryClientFactory(@Nullable SentryClientFactory clientFactory) {
        this.sentryClientFactory = clientFactory == null ? SentryClientFactory.instantiateFrom(this.getLookup(), this.getDsn()) : clientFactory;
    }

    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(@Nullable String dsn) {
        this.dsn = SentryOptions.resolveDsn(this.getLookup(), dsn);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void setLookup(Lookup lookup) {
        this.lookup = Objects.requireNonNull(lookup);
    }

    @Deprecated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Deprecated
    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private static String resolveDsn(Lookup lookup, @Nullable String dsn) {
        try {
            if (Util.isNullOrEmpty(dsn)) {
                dsn = Dsn.dsnFrom(lookup);
            }
            return dsn;
        }
        catch (RuntimeException e) {
            logger.error("Error creating valid DSN from: '{}'.", (Object)dsn, (Object)e);
            throw e;
        }
    }

    private final class InvalidSentryClientFactory
    extends SentryClientFactory {
        private InvalidSentryClientFactory() {
            super(SentryOptions.this.getLookup());
        }

        @Override
        public SentryClient createSentryClient(Dsn newDsn) {
            return null;
        }
    }
}

