/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.app.nstweaker;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import ru.turikhay.app.nstweaker.TweakApplier;
import ru.turikhay.app.nstweaker.TweakHostnameService;

public class TweakSslSocketFactory
extends SSLSocketFactory {
    private final TweakHostnameService service;
    private final SSLSocketFactory defaultSSLSocketFactory;

    public TweakSslSocketFactory(TweakHostnameService service) {
        this(service, TweakApplier.getTweakedSocketFactory());
    }

    public TweakSslSocketFactory(TweakHostnameService service, SSLSocketFactory defaultSSLSocketFactory) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        if (defaultSSLSocketFactory == null) {
            throw new NullPointerException("socketFactory");
        }
        this.service = service;
        this.defaultSSLSocketFactory = defaultSSLSocketFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.defaultSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean b) throws IOException {
        InetAddress newAddress = this.service.lookupHostAddr(host);
        if (newAddress != null) {
            try {
                socket.close();
            }
            catch (IOException ioE) {
                // empty catch block
            }
            return this.defaultSSLSocketFactory.createSocket(newAddress, port);
        }
        return this.defaultSSLSocketFactory.createSocket(socket, host, port, b);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetAddress newAddress = this.service.lookupHostAddr(host);
        if (newAddress != null) {
            return this.defaultSSLSocketFactory.createSocket(newAddress, port);
        }
        return this.defaultSSLSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        InetAddress newAddress = this.service.lookupHostAddr(host);
        if (newAddress != null) {
            return this.defaultSSLSocketFactory.createSocket(newAddress, port, localAddress, localPort);
        }
        return this.defaultSSLSocketFactory.createSocket(host, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        InetAddress newAddress = this.service.lookupHostAddr(inetAddress.getHostName());
        if (newAddress != null) {
            inetAddress = newAddress;
        }
        return this.defaultSSLSocketFactory.createSocket(inetAddress, port);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port, InetAddress localAddress, int localPort) throws IOException {
        InetAddress newAddress = this.service.lookupHostAddr(inetAddress.getHostName());
        if (newAddress != null) {
            inetAddress = newAddress;
        }
        return this.defaultSSLSocketFactory.createSocket(inetAddress, port, localAddress, localPort);
    }
}

