/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.app.nstweaker;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.List;
import ru.turikhay.app.nstweaker.TweakHostname;
import sun.net.spi.nameservice.NameService;

public class TweakHostnameService {
    private final Hashtable<String, TweakHostname> hostnames;

    public TweakHostnameService(List<TweakHostname> hostnamesToTweak) {
        if (hostnamesToTweak == null) {
            throw new NullPointerException("hostnames");
        }
        if (hostnamesToTweak.isEmpty()) {
            throw new NullPointerException("hostnames");
        }
        this.hostnames = new Hashtable(hostnamesToTweak.size());
        for (TweakHostname th : hostnamesToTweak) {
            this.hostnames.put(th.getHost(), th);
        }
    }

    public Object getDelegated(Object delegate) {
        final NameService parent = (NameService)delegate;
        return new NameService(){

            public InetAddress[] lookupAllHostAddr(String s) throws UnknownHostException {
                try {
                    return TweakHostnameService.this.lookupAllHostAddr(s);
                }
                catch (UnknownHostException ex) {
                    if (parent != null) {
                        return parent.lookupAllHostAddr(s);
                    }
                    throw ex;
                }
            }

            public String getHostByAddr(byte[] bytes) throws UnknownHostException {
                try {
                    return TweakHostnameService.this.getHostByAddr(bytes);
                }
                catch (UnknownHostException ex) {
                    if (parent != null) {
                        return parent.getHostByAddr(bytes);
                    }
                    throw ex;
                }
            }
        };
    }

    public InetAddress lookupHostAddr(String host) {
        TweakHostname tweakHostname = this.hostnames.get(host);
        if (tweakHostname == null) {
            return null;
        }
        return tweakHostname.getAddress();
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        InetAddress tweakAddress = this.lookupHostAddr(host);
        if (tweakAddress == null) {
            throw new UnknownHostException(host);
        }
        return new InetAddress[]{tweakAddress};
    }

    public String getHostByAddr(byte[] bytes) throws UnknownHostException {
        throw new UnknownHostException();
    }
}

