/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.app.nstweaker;

import java.net.InetAddress;
import java.net.UnknownHostException;
import ru.turikhay.app.nstweaker.IPUtil;

public class TweakHostname {
    private final InetAddress address;
    private final String host;

    public TweakHostname(byte[] ip, String host) {
        if (ip.length != 4 && ip.length != 16) {
            throw new IllegalArgumentException("illegal ip size");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("hostname cannot be empty");
        }
        try {
            this.address = InetAddress.getByAddress(host, ip);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("illegal ip size", e);
        }
        this.host = host;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getHost() {
        return this.host;
    }

    public static TweakHostname ipv4(String ip, String host) {
        return new TweakHostname(IPUtil.ip4(ip), host);
    }

    public static TweakHostname ipv6(String ip, String host) {
        return new TweakHostname(IPUtil.ip6(ip), host);
    }
}

