/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.app.nstweaker;

import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.reflect.FieldUtils;
import ru.turikhay.app.nstweaker.TweakHostname;
import ru.turikhay.app.nstweaker.TweakHostnameService;
import sun.net.spi.nameservice.NameService;

public final class TweakApplier {
    private static final AtomicBoolean nsCalled;
    private static final AtomicBoolean sslCalled;
    private static final SSLContext tweakedSSLContext;
    private static final HostnameVerifier tweakedHostnameVerifier;

    public static void applyNs(List<TweakHostname> hostnameList) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        if (nsCalled.getAndSet(true)) {
            return;
        }
        TweakHostnameService service = new TweakHostnameService(hostnameList);
        try {
            TweakApplier.tryNsList(service);
        }
        catch (Throwable t) {
            t.printStackTrace();
            TweakApplier.tryNsStandalone(service);
        }
    }

    private static void tryNsList(TweakHostnameService service) throws NoSuchFieldException, IllegalAccessException {
        List nameServices = (List)TweakApplier.readStaticField(InetAddress.class, "nameServices");
        ArrayList nsCopy = new ArrayList(nameServices);
        nameServices.clear();
        nameServices.add((NameService)service.getDelegated(null));
        nameServices.addAll(nsCopy);
    }

    private static void tryNsStandalone(TweakHostnameService service) throws NoSuchFieldException, IllegalAccessException {
        NameService nameService = (NameService)TweakApplier.readStaticField(InetAddress.class, "nameService");
        TweakApplier.writeStaticField(InetAddress.class, "nameService", service.getDelegated(nameService));
    }

    public static void applyHttpsSsl() {
        if (sslCalled.getAndSet(true)) {
            return;
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(TweakApplier.getTweakedSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
    }

    private static Object readStaticField(Class clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return FieldUtils.readStaticField(InetAddress.class, fieldName, true);
    }

    private static void writeStaticField(Class clazz, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        FieldUtils.writeStaticField(InetAddress.class, fieldName, (Object)true);
    }

    public static SSLSocketFactory getTweakedSocketFactory() {
        return tweakedSSLContext.getSocketFactory();
    }

    public static HostnameVerifier getTweakedHostnameVerifier() {
        return tweakedHostnameVerifier;
    }

    private TweakApplier() {
        throw new RuntimeException();
    }

    static {
        SSLContext context;
        nsCalled = new AtomicBoolean();
        sslCalled = new AtomicBoolean();
        try {
            context = SSLContext.getInstance("SSL");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        tweakedSSLContext = context;
        tweakedHostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }
}

