/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.app.nstweaker;

import java.util.ArrayList;
import java.util.List;
import ru.turikhay.app.nstweaker.TweakApplier;
import ru.turikhay.app.nstweaker.TweakHostname;
import sun.net.spi.nameservice.NameService;
import sun.net.util.IPAddressUtil;

public class NSTweaker {
    private static String SYSTEM_PROPERTY_PREFIX = "ru.turikhay.mcleaks.nstweaker.";
    private static char OUTER_SPLIT = (char)124;
    private static char INNER_SPLIT = (char)59;

    public static void main(String[] args) throws Exception {
        String list;
        try {
            NSTweaker.checkSupported();
        }
        catch (Throwable t) {
            throw new Error("MCLEAKS TWEAKS ARE NOT SUPPORTED", t);
        }
        if (Boolean.getBoolean(SYSTEM_PROPERTY_PREFIX + "hostname") && (list = System.getProperty(SYSTEM_PROPERTY_PREFIX + "hostname.list")) != null) {
            TweakApplier.applyNs(NSTweaker.fromTweakHostnameList(list));
        }
        if (Boolean.getBoolean(SYSTEM_PROPERTY_PREFIX + "ssl")) {
            TweakApplier.applyHttpsSsl();
        }
        NSTweaker.redirect(args);
    }

    private static void redirect(String[] args) throws Exception {
        String mainClass = System.getProperty(SYSTEM_PROPERTY_PREFIX + "mainclass");
        if (mainClass == null) {
            throw new IllegalArgumentException("no main class specified");
        }
        Class<?> clazz = Class.forName(mainClass);
        clazz.getMethod("main", String[].class).invoke(null, new Object[]{args});
    }

    public static List<TweakHostname> fromTweakHostnameList(String s) {
        String outerSplit = "" + '\\' + OUTER_SPLIT;
        String[] pairs = s.split(outerSplit);
        ArrayList<TweakHostname> list = new ArrayList<TweakHostname>(pairs.length);
        String innerSplit = "" + '\\' + INNER_SPLIT;
        for (String s_pair : pairs) {
            String[] pair = s_pair.split(innerSplit);
            if (pair.length != 2) {
                throw new IllegalArgumentException("cannot split pair: " + s_pair);
            }
            String hostname = pair[0];
            String ip = pair[1];
            list.add(TweakHostname.ipv4(ip, hostname));
        }
        return list;
    }

    public static String toTweakHostnameList(List<TweakHostname> list) {
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (TweakHostname hostname : list) {
            b.append(OUTER_SPLIT).append(hostname.getHost()).append(INNER_SPLIT).append(hostname.getAddress().getHostAddress());
        }
        return b.substring(1);
    }

    public static void checkSupported() throws ClassNotFoundException {
        IPAddressUtil.class.toString();
        NameService.class.toString();
    }
}

