/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.jarscanner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.jar.JarFile;
import me.cortex.jarscanner.Detector;
import me.cortex.jarscanner.Gui;
import me.cortex.jarscanner.Results;

public class Main {
    private static ExecutorService executorService;

    public static void main(String[] args) {
        if (!Main.checkArgs(args)) {
            return;
        }
        int nThreads = Integer.parseInt(args[0]);
        Path dirToCheck = new File(args[1]).toPath();
        boolean emitWalkErrors = false;
        if (args.length > 2) {
            emitWalkErrors = Boolean.parseBoolean(args[2]);
        }
        Function<String, String> logOutput = outputString -> {
            System.out.println((String)outputString);
            return outputString;
        };
        logOutput.apply("Starting scan...");
        Results results = null;
        try {
            results = Main.run(nThreads, dirToCheck, emitWalkErrors, logOutput);
        }
        catch (IOException e) {
            logOutput.apply("An error occurred while scanning the directory: " + dirToCheck);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            logOutput.apply("An error occurred while waiting for the scan to complete.");
            e.printStackTrace();
        }
        Main.outputRunResults(results, logOutput);
    }

    public static void outputRunResults(Results results, Function<String, String> logOutput) {
        if (results == null) {
            logOutput.apply("Scan failed. Unable to display results.");
        } else {
            List<String> stage1Detections = results.getStage1Detections();
            List<String> stage2Detections = results.getStage2Detections();
            if (stage1Detections.isEmpty() && stage2Detections.isEmpty()) {
                logOutput.apply("\u001b[32mScan complete. No infected jars found.\u001b[0m");
            } else {
                int i;
                logOutput.apply("\u001b[31mScan complete. Infections found!\u001b[0m");
                if (!stage1Detections.isEmpty()) {
                    logOutput.apply("\u001b[31mStage 1 Infections (" + stage1Detections.size() + "):" + "\u001b[0m");
                    for (i = 0; i < stage1Detections.size(); ++i) {
                        String stage1Infection = stage1Detections.get(i);
                        int stage1InfectionNumber = i + 1;
                        logOutput.apply("\u001b[31m[" + stage1InfectionNumber + "] " + "\u001b[37m" + stage1Infection + "\u001b[0m");
                    }
                }
                if (!stage2Detections.isEmpty()) {
                    logOutput.apply("\u001b[31mStage 2 Infections (" + stage2Detections.size() + "):" + "\u001b[0m");
                    for (i = 0; i < stage2Detections.size(); ++i) {
                        String stage2Infection = stage2Detections.get(i);
                        int stage2InfectionNumber = i + 1;
                        logOutput.apply("\u001b[31m[" + stage2InfectionNumber + "] " + "\u001b[37m" + stage2Infection + "\u001b[0m");
                    }
                }
            }
        }
    }

    public static Results run(int nThreads, Path dirToCheck, final boolean emitWalkErrors, final Function<String, String> logOutput) throws IOException, InterruptedException {
        boolean timedOut;
        long startTime = System.currentTimeMillis();
        logOutput.apply("\u001b[32mStarting All Scans - \u001b[0mThis may take a while depending on the size of the directories and JAR files.");
        File dirToCheckFile = dirToCheck.toFile();
        if (!dirToCheckFile.exists()) {
            throw new IllegalArgumentException("Specified directory does not exist: " + dirToCheck);
        }
        if (!dirToCheckFile.isDirectory()) {
            throw new IllegalArgumentException("Specified directory is not a directory: " + dirToCheck);
        }
        if (nThreads < 1) {
            throw new IllegalArgumentException("Number of threads must be at least 1");
        }
        executorService = Executors.newFixedThreadPool(nThreads);
        long stage1StartTime = System.currentTimeMillis();
        logOutput.apply("\u001b[32mRunning Stage 1 Scan...\u001b[0m");
        final ArrayList<String> stage1InfectionsList = new ArrayList<String>();
        Files.walkFileTree(dirToCheck, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                boolean isScannable = file.toString().toLowerCase().endsWith(".jar");
                if (isScannable) {
                    executorService.submit(() -> {
                        block10: {
                            try (JarFile scannableJarFile = new JarFile(file.toFile());){
                                boolean infectionDetected = Detector.scan(scannableJarFile, file, logOutput);
                                if (!infectionDetected) break block10;
                                List list = stage1InfectionsList;
                                synchronized (list) {
                                    stage1InfectionsList.add(file.toString());
                                }
                            }
                            catch (Exception e) {
                                if (!emitWalkErrors) break block10;
                                logOutput.apply("Failed to scan Jar file: " + file);
                                e.printStackTrace();
                            }
                        }
                    });
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                if (emitWalkErrors) {
                    logOutput.apply("Failed to access file: " + file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                if (exc != null && emitWalkErrors) {
                    logOutput.apply("Failed to access directory: " + dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        executorService.shutdown();
        boolean bl = timedOut = !executorService.awaitTermination(100000L, TimeUnit.DAYS);
        if (timedOut) {
            logOutput.apply("Timed out while waiting for Jar scanning to complete.");
        }
        long stage1EndTime = System.currentTimeMillis();
        long stage1Time = stage1EndTime - stage1StartTime;
        logOutput.apply("\u001b[32mStage 1 Scan Complete - \u001b[0mTook  " + stage1Time + "ms.");
        long stage2StartTime = System.currentTimeMillis();
        logOutput.apply("\u001b[32mRunning Stage 2 Scan...\u001b[0m");
        List<String> stage2InfectionsList = Detector.checkForStage2();
        long stage2EndTime = System.currentTimeMillis();
        long stage2Time = stage2EndTime - stage2StartTime;
        logOutput.apply("\u001b[32mStage 2 Scan Complete - \u001b[0mTook  " + stage2Time + "ms.");
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        logOutput.apply("\u001b[32mAll Scans Complete - \u001b[0mTotal " + totalTime + "ms.");
        return new Results(stage1InfectionsList, stage2InfectionsList);
    }

    public static void cancelScanIfRunning() {
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    private static boolean checkArgs(String[] args) {
        int nThreads;
        if (args.length == 0) {
            Gui.main(args);
            return false;
        }
        try {
            nThreads = Integer.parseInt(args[0]);
        }
        catch (Exception e) {
            System.err.println("Invalid thread count, please use an integer.");
            return false;
        }
        if (nThreads <= 0) {
            System.err.println("Invalid thread count, must be greater than 0.");
            return false;
        }
        File dirToCheck = null;
        try {
            dirToCheck = new File(args[1]);
        }
        catch (Exception e) {
            System.err.println("Invalid path, unable to load.");
            return false;
        }
        if (!dirToCheck.exists()) {
            System.err.println("Invalid path, directory does not exist.");
            return false;
        }
        if (!dirToCheck.isDirectory()) {
            System.err.println("Invalid path, not a directory.");
            return false;
        }
        return true;
    }
}

