/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.jarscanner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import me.cortex.jarscanner.Main;
import me.cortex.jarscanner.Results;

public class Gui {
    public static boolean USING_GUI;
    private static JTextArea textArea;
    private static JButton searchDirPicker;
    private static Path searchDir;
    private static Thread scanThread;
    private static String[] credits;

    public static void main(String[] args) {
        Gui.createAndDisplayGui();
    }

    private static void createAndDisplayGui() {
        USING_GUI = true;
        textArea = new JTextArea(20, 40);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JLabel searchDirPickerLabel = new JLabel("Select Search Directory:");
        searchDirPickerLabel.setAlignmentX(0.5f);
        searchDirPicker = new JButton(new File(System.getProperty("user.home")).getName());
        searchDirPicker.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setFileHidingEnabled(false);
            int option = fileChooser.showOpenDialog(frame);
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                searchDir = file.toPath();
                searchDirPicker.setText(file.getName());
            }
        });
        JButton credsButton = new JButton("Credits");
        credsButton.addActionListener(e -> Gui.showCredits());
        JCheckBox autoScrollCheckBox = new JCheckBox("Auto-scroll");
        autoScrollCheckBox.setSelected(true);
        JButton cancelButton = new JButton("Cancel!");
        cancelButton.setEnabled(false);
        cancelButton.addActionListener(e -> {
            if (scanThread != null) {
                Main.cancelScanIfRunning();
                scanThread.interrupt();
            }
        });
        JButton runButton = new JButton("Run!");
        runButton.addActionListener(e -> {
            scanThread = new Thread(() -> {
                searchDirPicker.setEnabled(false);
                runButton.setEnabled(false);
                cancelButton.setEnabled(true);
                try {
                    Function<String, String> logOutput = out -> {
                        String processedOut = out.replace("\u001b[31m", "").replace("\u001b[32m", "").replace("\u001b[37m", "").replace("\u001b[0m", "");
                        textArea.append(processedOut + "\n");
                        if (autoScrollCheckBox.isSelected()) {
                            textArea.setCaretPosition(textArea.getDocument().getLength());
                        }
                        return out;
                    };
                    Results run = Main.run(4, searchDir, true, logOutput);
                    Main.outputRunResults(run, logOutput);
                    textArea.append("Done scanning!");
                }
                catch (Exception ex) {
                    if (ex instanceof InterruptedException || ex instanceof RejectedExecutionException) {
                        textArea.append("Scan cancelled!\n");
                    }
                    textArea.append("Error while running scan!\n");
                }
                searchDirPicker.setEnabled(true);
                runButton.setEnabled(true);
                cancelButton.setEnabled(false);
            });
            scanThread.start();
        });
        frame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        buttonPanel.add((Component)runButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        buttonPanel.add((Component)cancelButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        buttonPanel.add((Component)credsButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        buttonPanel.add((Component)autoScrollCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 12;
        frame.getContentPane().add((Component)buttonPanel, gridBagConstraints);
        JPanel searchDirPickerPanel = new JPanel();
        searchDirPickerPanel.add(searchDirPickerLabel);
        searchDirPickerPanel.add(searchDirPicker);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 18;
        frame.getContentPane().add((Component)searchDirPickerPanel, gridBagConstraints);
        JScrollPane logAreaPanel = Gui.createTextArea();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        frame.getContentPane().add((Component)logAreaPanel, gridBagConstraints);
        frame.pack();
        frame.setTitle("Neko Detector");
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        frame.setMinimumSize(new Dimension(600, 300));
        frame.setMaximumSize(new Dimension(600, 300));
        frame.setPreferredSize(new Dimension(600, 300));
    }

    private static void showCredits() {
        JFrame frame = new JFrame("Credits");
        JTextArea credits = new JTextArea();
        credits.setEditable(false);
        for (String string : Gui.credits) {
            credits.append(string + "\n");
        }
        frame.add(credits);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    private static JScrollPane createTextArea() {
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setEditable(false);
        return scrollPane;
    }

    static {
        searchDir = new File(System.getProperty("user.home")).toPath();
        credits = new String[]{"Credits to:", "Cortex, for decompiling and deobfuscating the malware, and making the initial detector.", "D3SL: Extensive reverse engineering, early discovery learned of later", "Nia: Extensive Stage 3 reverse engineering", "Jasmine: Coordination, writing the decompiler we've been using (Quiltflower)", "Emi: Coordination, initial discovery (for this team), and early research", "williewillus: Coordination, journalist", "quat: Documentation, initial infected sample research", "xylemlandmark: Coordination of documentation, crowd control", "Vazkii: they're pretty neat", "Elocin: Originally finding the malware itself"};
    }
}

