/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.jarscanner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Detector {
    private static final AbstractInsnNode[] SIG1 = new AbstractInsnNode[]{new TypeInsnNode(187, "java/lang/String"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new TypeInsnNode(187, "java/lang/String"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"), new MethodInsnNode(182, "java/lang/Class", "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(183, "java/net/URL", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V"), new MethodInsnNode(182, "java/lang/reflect/Constructor", "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;"), new MethodInsnNode(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"), new MethodInsnNode(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;")};
    private static final AbstractInsnNode[] SIG2 = new AbstractInsnNode[]{new MethodInsnNode(184, "java/lang/Runtime", "getRuntime", "()Ljava/lang/Runtime;"), new MethodInsnNode(184, "java/util/Base64", "getDecoder", "()Ljava/util/Base64$Decoder;"), new MethodInsnNode(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;"), new MethodInsnNode(182, "java/util/Base64$Decoder", "decode", "(Ljava/lang/String;)[B"), new MethodInsnNode(183, "java/lang/String", "<init>", "([B)V"), new MethodInsnNode(182, "java/io/File", "getPath", "()Ljava/lang/String;"), new MethodInsnNode(182, "java/lang/Runtime", "exec", "([Ljava/lang/String;)Ljava/lang/Process;")};
    private static final AbstractInsnNode[] SIG3 = new AbstractInsnNode[]{new IntInsnNode(16, 56), new InsnNode(84), new InsnNode(89), new InsnNode(4), new IntInsnNode(16, 53), new InsnNode(84), new InsnNode(89), new InsnNode(5), new IntInsnNode(16, 46), new InsnNode(84), new InsnNode(89), new InsnNode(6), new IntInsnNode(16, 50), new InsnNode(84), new InsnNode(89), new InsnNode(7), new IntInsnNode(16, 49), new InsnNode(84), new InsnNode(89), new InsnNode(8), new IntInsnNode(16, 55), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 6), new IntInsnNode(16, 46), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 7), new IntInsnNode(16, 49), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 8), new IntInsnNode(16, 52), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 9), new IntInsnNode(16, 52), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 10), new IntInsnNode(16, 46), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 11), new IntInsnNode(16, 49), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 12), new IntInsnNode(16, 51), new InsnNode(84), new InsnNode(89), new IntInsnNode(16, 13), new IntInsnNode(16, 48)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean scan(JarFile file, Path path, Function<String, String> output) {
        boolean signatureMatchFound = false;
        try {
            signatureMatchFound = file.stream().filter(entry -> entry.getName().endsWith(".class")).anyMatch(entry -> {
                try {
                    return Detector.scanClass(Detector.getByteArray(file.getInputStream((ZipEntry)entry)));
                }
                catch (IOException e) {
                    output.apply("Failed to scan class in Jar file [" + path + "] due to an IO error: " + entry.getName());
                    output.apply("Error:" + e.getMessage());
                    return false;
                }
                catch (IllegalArgumentException e) {
                    output.apply("Failed to scan class in Jar file [" + path + "] due to a parsing error: " + entry.getName());
                    output.apply("This is likely due to a malformed class file or an issue with the JAR file itself.");
                    output.apply("Error:" + e.getMessage());
                    return false;
                }
            });
        }
        catch (Exception e) {
            output.apply("Failed to scan Jar file: " + path);
            output.apply("Error:" + e.getMessage());
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e) {
                output.apply("Failed to close Jar file after scan: " + path);
                output.apply("Error:" + e.getMessage());
            }
        }
        return signatureMatchFound;
    }

    private static byte[] getByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    private static boolean same(AbstractInsnNode a, AbstractInsnNode b) {
        if (a instanceof TypeInsnNode) {
            TypeInsnNode aa = (TypeInsnNode)a;
            return aa.desc.equals(((TypeInsnNode)b).desc);
        }
        if (a instanceof MethodInsnNode) {
            MethodInsnNode aa = (MethodInsnNode)a;
            return aa.owner.equals(((MethodInsnNode)b).owner) && aa.name.equals(((MethodInsnNode)b).name) && aa.desc.equals(((MethodInsnNode)b).desc);
        }
        if (a instanceof InsnNode) {
            return true;
        }
        throw new IllegalArgumentException("TYPE NOT ADDED");
    }

    public static boolean scanClass(byte[] clazz) {
        ClassReader reader = new ClassReader(clazz);
        ClassNode node = new ClassNode();
        try {
            reader.accept(node, 0);
        }
        catch (Exception e) {
            return false;
        }
        for (MethodNode method : node.methods) {
            AbstractInsnNode insn;
            int i;
            boolean match = true;
            int j = 0;
            for (i = 0; i < method.instructions.size() && j < SIG1.length; ++i) {
                insn = method.instructions.get(i);
                if (insn.getOpcode() == -1 || insn.getOpcode() != SIG1[j].getOpcode() || Detector.same(insn, SIG1[j++])) continue;
                match = false;
                break;
            }
            if (j != SIG1.length) {
                match = false;
            }
            if (match) {
                return true;
            }
            match = false;
            block4: for (int q = 0; q < method.instructions.size(); ++q) {
                int j2 = 0;
                for (int i2 = q; i2 < method.instructions.size() && j2 < SIG2.length; ++i2) {
                    AbstractInsnNode insn2 = method.instructions.get(i2);
                    if (insn2.getOpcode() == SIG2[j2].getOpcode() && insn2.getOpcode() == SIG2[j2].getOpcode() && !Detector.same(insn2, SIG2[j2++])) continue block4;
                }
                if (j2 != SIG2.length) continue;
                match = true;
                break;
            }
            if (match) {
                return true;
            }
            match = false;
            int pos = 0;
            for (i = 0; i < method.instructions.size() && pos != SIG3.length; ++i) {
                insn = method.instructions.get(i);
                if (insn.getOpcode() == -1) continue;
                if (insn.getOpcode() == SIG3[pos].getOpcode()) {
                    if (SIG3[pos].getType() == 1) {
                        IntInsnNode iInsn = (IntInsnNode)insn;
                        IntInsnNode sigInsn = (IntInsnNode)SIG3[pos];
                        if (iInsn.operand != sigInsn.operand) continue;
                        match = true;
                        ++pos;
                        continue;
                    }
                    match = true;
                    ++pos;
                    continue;
                }
                match = false;
                pos = 0;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static List<String> checkForStage2() {
        File file;
        ArrayList<String> suspiciousFilesFound = new ArrayList<String>();
        Path windowsStartupDirectory = (Objects.isNull(System.getenv("APPDATA")) ? Paths.get(System.getProperty("user.home"), "AppData", "Roaming") : Paths.get(System.getenv("APPDATA"), new String[0])).resolve(Paths.get("Microsoft", "Windows", "Start Menu", "Programs", "Startup"));
        boolean windows = Files.isDirectory(windowsStartupDirectory, new LinkOption[0]) && Files.isWritable(windowsStartupDirectory);
        String[] maliciousFiles = new String[]{".ref", "client.jar", "lib.dll", "libWebGL64.jar", "run.bat"};
        if (windows) {
            File startFolder;
            File edgeFolder = new File(System.getenv("APPDATA") + "\\Microsoft Edge");
            if (edgeFolder.exists()) {
                suspiciousFilesFound.add(edgeFolder.getAbsolutePath());
            }
            if ((startFolder = new File("Microsoft\\Windows\\Start Menu\\Programs\\Startup")).exists() && startFolder.isDirectory()) {
                File[] startFiles = startFolder.listFiles();
                for (int i = 0; i < startFiles.length; ++i) {
                    for (int j = 0; j < maliciousFiles.length; ++j) {
                        if (!startFiles[i].getName().equals(maliciousFiles[j])) continue;
                        suspiciousFilesFound.add(startFiles[i].getAbsolutePath());
                    }
                }
            }
        }
        if (System.getProperty("os.name").toLowerCase().contains("linux") && (file = new File("~/.config/.data/lib.jar")).exists()) {
            suspiciousFilesFound.add(file.getAbsolutePath());
        }
        return suspiciousFilesFound;
    }
}

