/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.windows.wmi;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ru.turikhay.util.windows.wmi.CodepageException;
import ru.turikhay.util.windows.wmi.WMI;

public final class Codepage {
    private final int codepage;
    private final String charsetName;
    private final Charset charset;
    private static final Map<Integer, Codepage> knownCodepages = new HashMap<Integer, Codepage>();
    private static Codepage instance;

    private Codepage(int codepage, String charsetName, Charset charset) {
        this.codepage = codepage;
        this.charsetName = charsetName;
        this.charset = charset;
    }

    public int getCodepage() {
        return this.codepage;
    }

    public Charset getCharset() throws UnsupportedCharsetException {
        if (this.charset == null) {
            throw new UnsupportedCharsetException(this.charsetName);
        }
        return this.charset;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("codepage", this.codepage);
        if (this.charset == null) {
            b.append("charsetName", (Object)this.charsetName);
        } else {
            b.append("charset", (Object)this.charset);
        }
        return b.build();
    }

    public static Codepage get() throws CodepageException {
        if (instance == null) {
            instance = Codepage.doDetect();
        }
        return instance;
    }

    public static Codepage getCodepage(int codepage) {
        return knownCodepages.get(codepage);
    }

    private static Codepage doDetect() throws CodepageException {
        String chcpResponse = Codepage.queryChcp();
        Matcher matcher = Pattern.compile(".*: ([\\d]+)[.]?").matcher(chcpResponse);
        if (matcher.matches() && matcher.groupCount() == 1) {
            int cp;
            try {
                cp = Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                throw new RuntimeException("could not parse chcp: \"" + matcher.group(1) + "\"", e);
            }
            Codepage codepage = Codepage.getCodepage(cp);
            if (codepage == null) {
                throw new CodepageException("chcp returned unknown codepage: " + cp);
            }
            return codepage;
        }
        throw new CodepageException("chcp returned unexpected response; lines: \"" + chcpResponse + "\"");
    }

    private static String queryChcp() throws CodepageException {
        List<String> result;
        String system32 = System.getenv("WINDIR") + "\\system32\\";
        try {
            result = WMI.execute(new String[]{system32 + "chcp.com"}, StandardCharsets.US_ASCII);
        }
        catch (Exception e) {
            throw new CodepageException("Couldn't run chcp.com", e);
        }
        if (result.isEmpty()) {
            throw new CodepageException("chcp returned no lines");
        }
        return result.get(result.size() - 1);
    }

    private static void add(int codepage, String charsetName) {
        Charset charset;
        try {
            charset = Charset.forName(charsetName);
        }
        catch (RuntimeException rE) {
            charset = null;
        }
        knownCodepages.put(codepage, new Codepage(codepage, charsetName, charset));
    }

    static {
        Codepage.add(37, "IBM037");
        Codepage.add(437, "IBM437");
        Codepage.add(500, "IBM500");
        Codepage.add(708, "ASMO-708");
        Codepage.add(720, "Windows-1256");
        Codepage.add(737, "ibm737");
        Codepage.add(775, "ibm775");
        Codepage.add(850, "ibm850");
        Codepage.add(852, "ibm852");
        Codepage.add(855, "IBM855");
        Codepage.add(857, "ibm857");
        Codepage.add(858, "IBM00858");
        Codepage.add(860, "IBM860");
        Codepage.add(861, "ibm861");
        Codepage.add(862, "ibm862");
        Codepage.add(863, "IBM863");
        Codepage.add(864, "IBM864");
        Codepage.add(865, "IBM865");
        Codepage.add(866, "CP866");
        Codepage.add(869, "ibm869");
        Codepage.add(870, "IBM870");
        Codepage.add(874, "windows-874");
        Codepage.add(875, "cp875");
        Codepage.add(932, "shift_jis");
        Codepage.add(936, "gb2312");
        Codepage.add(949, "ks_c_5601-1987");
        Codepage.add(950, "big5");
        Codepage.add(1026, "IBM1026");
        Codepage.add(1047, "IBM1047");
        Codepage.add(1140, "IBM01140");
        Codepage.add(1141, "IBM01141");
        Codepage.add(1142, "IBM01142");
        Codepage.add(1143, "IBM01143");
        Codepage.add(1144, "IBM01144");
        Codepage.add(1145, "IBM01145");
        Codepage.add(1146, "IBM01146");
        Codepage.add(1147, "IBM01147");
        Codepage.add(1148, "IBM01148");
        Codepage.add(1149, "IBM01149");
        Codepage.add(1200, "utf-16");
        Codepage.add(1250, "windows-1250");
        Codepage.add(1251, "windows-1251");
        Codepage.add(1252, "windows-1252");
        Codepage.add(1253, "windows-1253");
        Codepage.add(1254, "windows-1254");
        Codepage.add(1255, "windows-1255");
        Codepage.add(1256, "windows-1256");
        Codepage.add(1257, "windows-1257");
        Codepage.add(1258, "windows-1258");
        Codepage.add(1361, "Johab");
        Codepage.add(10004, "x-macarabic");
        Codepage.add(10005, "x-machebrew");
        Codepage.add(10006, "x-macgreek");
        Codepage.add(10007, "x-maccyrillic");
        Codepage.add(10010, "x-macromania");
        Codepage.add(10017, "x-macukraine");
        Codepage.add(10021, "x-macthai");
        Codepage.add(10029, "x-MacCentralEurope");
        Codepage.add(10079, "x-maciceland");
        Codepage.add(10081, "x-macturkish");
        Codepage.add(12000, "utf-32");
        Codepage.add(12001, "utf-32BE");
        Codepage.add(20000, "ISO-2022-CN");
        Codepage.add(20127, "us-ascii");
        Codepage.add(20273, "IBM273");
        Codepage.add(20277, "IBM277");
        Codepage.add(20278, "IBM278");
        Codepage.add(20280, "IBM280");
        Codepage.add(20284, "IBM284");
        Codepage.add(20285, "IBM285");
        Codepage.add(20290, "IBM290");
        Codepage.add(20297, "IBM297");
        Codepage.add(20420, "IBM420");
        Codepage.add(20424, "IBM424");
        Codepage.add(20838, "IBM-Thai");
        Codepage.add(20866, "koi8-r");
        Codepage.add(20871, "IBM871");
        Codepage.add(20932, "EUC-JP");
        Codepage.add(21025, "cp1025");
        Codepage.add(21866, "koi8-u");
        Codepage.add(28591, "iso-8859-1");
        Codepage.add(28592, "iso-8859-2");
        Codepage.add(28593, "iso-8859-3");
        Codepage.add(28594, "iso-8859-4");
        Codepage.add(28595, "iso-8859-5");
        Codepage.add(28596, "iso-8859-6");
        Codepage.add(28597, "iso-8859-7");
        Codepage.add(28598, "iso-8859-8");
        Codepage.add(28599, "iso-8859-9");
        Codepage.add(28603, "iso-8859-13");
        Codepage.add(28605, "iso-8859-15");
        Codepage.add(50220, "iso-2022-jp");
        Codepage.add(50221, "csISO2022JP");
        Codepage.add(50222, "iso-2022-jp");
        Codepage.add(50225, "iso-2022-kr");
        Codepage.add(51932, "euc-jp");
        Codepage.add(51936, "EUC-CN");
        Codepage.add(51949, "euc-kr");
        Codepage.add(54936, "GB18030");
        Codepage.add(65001, "utf-8");
    }
}

