/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.windows.dxdiag;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.windows.dxdiag.DxDiagReport;
import ru.turikhay.util.windows.dxdiag.IScheduledTaskFactory;
import ru.turikhay.util.windows.dxdiag.SuccessiveScheduledTaskFactory;
import ru.turikhay.util.windows.dxdiag.TaskFactory;

class TimeLimitedTask
implements Callable<DxDiagReport> {
    private static final long DEFAULT_LIMIT_IN_SECONDS = 120L;
    private static final Logger LOGGER = LogManager.getLogger(TimeLimitedTask.class);
    private final Future<DxDiagReport> reportTask;
    private final long timeout;
    private final TimeUnit timeUnit;

    TimeLimitedTask(Future<DxDiagReport> reportTask, long timeout, TimeUnit timeUnit) {
        this.reportTask = reportTask;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    TimeLimitedTask(Future<DxDiagReport> reportTask) {
        this(reportTask, 120L, TimeUnit.SECONDS);
    }

    @Override
    public DxDiagReport call() throws Exception {
        try {
            return this.reportTask.get(this.timeout, this.timeUnit);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.warn("DxDiag did not complete in {} seconds", (Object)this.timeUnit.toSeconds(this.timeout));
            throw timeoutException;
        }
    }

    public static class Factory
    implements TaskFactory {
        private final IScheduledTaskFactory scheduledTaskFactory;

        public Factory(IScheduledTaskFactory scheduledTaskFactory) {
            this.scheduledTaskFactory = scheduledTaskFactory;
        }

        public Factory(TaskFactory taskFactory) {
            this(new SuccessiveScheduledTaskFactory(taskFactory));
        }

        public TimeLimitedTask createTask() {
            return new TimeLimitedTask(this.scheduledTaskFactory.getScheduledTask());
        }
    }
}

