/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.windows.dxdiag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import ru.turikhay.util.OS;
import ru.turikhay.util.windows.dxdiag.DisplayDevice;
import ru.turikhay.util.windows.dxdiag.DxDiagFailedException;
import ru.turikhay.util.windows.dxdiag.DxDiagReport;
import ru.turikhay.util.windows.dxdiag.Section;
import ru.turikhay.util.windows.dxdiag.SysInfo;
import ru.turikhay.util.windows.dxdiag.TaskFactory;

class DxDiagTask
implements Callable<DxDiagReport> {
    private static final Logger LOGGER = LogManager.getLogger(DxDiagTask.class);
    private File reportFile;

    public DxDiagTask(String osName, String osVersion, File reportFile) {
        this.reportFile = reportFile;
    }

    public DxDiagTask() {
        this(OS.NAME, OS.VERSION, null);
    }

    @Override
    public DxDiagReport call() throws Exception {
        DxDiagReport report;
        try {
            List<String> command = this.buildCommand();
            this.startAndWait(command);
            report = this.parseReportFile();
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception e) {
            LOGGER.error("DxDiag report failed", (Throwable)e);
            this.printReportFileContent();
            throw e;
        }
        LOGGER.debug("DxDiag report is complete");
        return report;
    }

    private File getOrCreateOutputFile() throws DxDiagFailedException {
        if (this.reportFile == null) {
            this.reportFile = DxDiagTask.createTempDxDiagFile();
        }
        return this.reportFile;
    }

    File getReportFile() {
        if (this.reportFile == null) {
            throw new NullPointerException("outputFile");
        }
        return this.reportFile;
    }

    File getNullableReportFile() {
        return this.reportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printReportFileContent() {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        File outputFile = this.getNullableReportFile();
        if (outputFile == null) {
            LOGGER.debug("Report file was not yet created");
            return;
        }
        LOGGER.debug("DxDiag report file content: {}", (Object)outputFile);
        LOGGER.debug("++++++++++++++++++++");
        try (Scanner scanner = new Scanner(outputFile);){
            while (scanner.hasNextLine()) {
                LOGGER.debug(scanner.nextLine());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Oops!", (Throwable)e);
        }
        finally {
            LOGGER.debug("++++++++++++++++++++");
        }
    }

    List<String> buildCommand() throws DxDiagFailedException {
        boolean dontSkip;
        ArrayList<String> command = new ArrayList<String>();
        command.add("cmd.exe");
        command.add("/c");
        command.add(DxDiagTask.getDxDiagExecutable().getAbsolutePath());
        command.add("/whql:off");
        try {
            dontSkip = Double.parseDouble(OS.VERSION) >= 7.0;
        }
        catch (RuntimeException rE) {
            LOGGER.warn("Could not determine Windows version: {}", (Object)OS.VERSION);
            boolean bl = dontSkip = !OS.NAME.toLowerCase(Locale.ROOT).contains("xp");
        }
        if (dontSkip) {
            command.add("/dontskip");
        }
        command.add("/x");
        command.add(this.getOrCreateOutputFile().getAbsolutePath());
        return command;
    }

    void startAndWait(List<String> command) throws InterruptedException, DxDiagFailedException {
        long millis;
        Process process;
        LOGGER.debug("Executing DxDiag command: {}", command);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            process = processBuilder.start();
        }
        catch (IOException ioE) {
            throw new DxDiagFailedException("cannot start process", ioE);
        }
        long start = System.currentTimeMillis();
        do {
            if ((millis = System.currentTimeMillis() - start) / 1000L % 5L == 0L) {
                LOGGER.debug("Waiting DxDiag to gather info about the system... ({} s)", (Object)(millis / 1000L));
            }
            Thread.sleep(1000L);
        } while (process.isAlive());
        int exitCode = process.exitValue();
        LOGGER.debug("Done in {} ms with exit code {} (0x{})", (Object)millis, (Object)exitCode, (Object)Integer.toHexString(exitCode));
        if (exitCode != 0) {
            throw new DxDiagFailedException("exit code: " + exitCode + " (0x" + Integer.toHexString(exitCode) + ")");
        }
    }

    DxDiagReport parseReportFile() throws DxDiagFailedException {
        Document jdomDocument;
        SAXBuilder jdomBuilder = new SAXBuilder();
        try {
            jdomDocument = jdomBuilder.build(this.getReportFile());
        }
        catch (IOException | JDOMException e) {
            throw new DxDiagFailedException("cannot parse report file", e);
        }
        Element root = jdomDocument.getRootElement();
        SysInfo sysInfo = new SysInfo(new Section(root, "SystemInformation"));
        ArrayList<DisplayDevice> displayDevices = new ArrayList<DisplayDevice>();
        Element displayDevicesElem = root.getChild("DisplayDevices");
        if (displayDevicesElem == null || root.getChild("DisplayDevices") == null) {
            LOGGER.debug("No display devices list");
        } else {
            List dd = root.getChild("DisplayDevices").getChildren("DisplayDevice");
            for (Element elem : dd) {
                displayDevices.add(new DisplayDevice(new Section(elem)));
            }
        }
        return new DxDiagReport(sysInfo, displayDevices);
    }

    private static File createTempDxDiagFile() throws DxDiagFailedException {
        File outputFile;
        try {
            outputFile = File.createTempFile("tlauncher-dxdiag", ".xml");
        }
        catch (IOException e) {
            throw new DxDiagFailedException("couldn't create temp file", e);
        }
        outputFile.deleteOnExit();
        return outputFile;
    }

    private static File getDxDiagExecutable() {
        return new File(System.getenv("WINDIR") + "\\system32\\dxdiag.exe");
    }

    public static class Factory
    implements TaskFactory {
        public DxDiagTask createTask() {
            return new DxDiagTask();
        }
    }
}

