/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.sysinfo;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.sysinfo.SystemInfo;
import ru.turikhay.util.sysinfo.SystemInfoReporter;

public class SequentialSystemInfoReporter
implements SystemInfoReporter {
    private static final Logger LOGGER = LogManager.getLogger(SequentialSystemInfoReporter.class);
    private final List<SystemInfoReporter> list;

    public SequentialSystemInfoReporter(SystemInfoReporter ... list) {
        if (list.length == 0) {
            throw new IllegalArgumentException();
        }
        this.list = Arrays.asList(list);
    }

    @Override
    public void queueReport() {
        this.list.get(0).queueReport();
    }

    @Override
    public CompletableFuture<SystemInfo> getReport() {
        CompletionStage<SystemInfo> r = new CompletableFuture<SystemInfo>();
        r.complete(null);
        for (SystemInfoReporter printer : this.list) {
            r = ((CompletableFuture)r.handle((result, ex) -> {
                if (ex != null) {
                    LOGGER.error("Couldn't query system info", ex);
                    return printer.getReport();
                }
                if (result == null) {
                    return printer.getReport();
                }
                return CompletableFuture.completedFuture(result);
            })).thenCompose(Function.identity());
        }
        return r;
    }

    public String toString() {
        return "SequentialSystemInfoReporter{list=" + this.list + '}';
    }
}

