/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.sysinfo;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import ru.turikhay.util.async.AsyncThread;
import ru.turikhay.util.sysinfo.GraphicsCard;
import ru.turikhay.util.sysinfo.SystemInfo;
import ru.turikhay.util.sysinfo.SystemInfoReporter;
import ru.turikhay.util.windows.dxdiag.DxDiag;
import ru.turikhay.util.windows.dxdiag.DxDiagReport;

public class DxDiagSystemInfoReporter
implements SystemInfoReporter {
    @Override
    public void queueReport() {
        DxDiag.getInstance().queueTask();
    }

    @Override
    public CompletableFuture<SystemInfo> getReport() {
        CompletableFuture<SystemInfo> f = new CompletableFuture<SystemInfo>();
        AsyncThread.execute(() -> this.checkIfDxDiagComplete(f));
        return f;
    }

    private void checkIfDxDiagComplete(CompletableFuture<SystemInfo> f) {
        Future<DxDiagReport> task = DxDiag.getInstanceTask();
        if (task.isDone()) {
            DxDiagReport result;
            try {
                result = task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                f.completeExceptionally(e);
                return;
            }
            AsyncThread.execute(() -> f.complete(this.convertDxDiagReport(result)));
            return;
        }
        AsyncThread.afterSeconds(1L, () -> this.checkIfDxDiagComplete(f));
    }

    private SystemInfo convertDxDiagReport(DxDiagReport report) {
        return new SystemInfo(Arrays.asList(report.getSysInfo().toString().split("\n")), report.getSysInfo().is64Bit(), report.getDisplayDevices().stream().map(d -> new GraphicsCard(d.getCardName(), d.getManufacturer(), d.getDriverVersion())).collect(Collectors.toList()));
    }
}

