/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.json;

import com.github.zafarkhaja.semver.Version;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.util.json.VersionSerializer;

public class LegacyVersionSerializer
extends VersionSerializer {
    private final Pattern legacyVersionPattern = Pattern.compile("([\\d])\\.([\\d])([\\d]?)([\\d]*)");

    @Override
    public Version deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Matcher matcher;
        double val;
        if (json == null) {
            return super.deserialize(null, typeOfT, context);
        }
        try {
            val = json.getAsDouble();
        }
        catch (NumberFormatException nfE) {
            return super.deserialize(json, typeOfT, context);
        }
        String str = String.valueOf(val);
        if (val > 0.0 && (matcher = this.legacyVersionPattern.matcher(str)).matches()) {
            return Version.forIntegers((int)LegacyVersionSerializer.pi(matcher.group(1)), (int)LegacyVersionSerializer.pi(matcher.group(2) + (LegacyVersionSerializer.ne(matcher.group(3)) ? matcher.group(3) : "0")), (int)(LegacyVersionSerializer.ne(matcher.group(4)) ? LegacyVersionSerializer.pi(matcher.group(4)) : 0));
        }
        return super.deserialize(json, typeOfT, context);
    }

    private static int pi(String v) {
        return Integer.parseInt(v);
    }

    private static boolean ne(String v) {
        return StringUtils.isNotBlank((CharSequence)v);
    }
}

