/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public class InstantAdapter
implements JsonSerializer<Instant>,
JsonDeserializer<Instant> {
    public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String value = Objects.requireNonNull(json.getAsString(), "date");
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new JsonParseException("cannot parse date: " + value, (Throwable)e);
        }
    }

    public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
        return src == null ? null : new JsonPrimitive(src.toString());
    }
}

