/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.http;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.ContentResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryingRangeContentResponseHandler
extends ContentResponseHandler {
    private static final Logger LOGGER = LogManager.getLogger(RetryingRangeContentResponseHandler.class);
    static final int BUFFER_SIZE = 4096;
    private final Request request;
    private final Executor executor;
    private final boolean enableSentryReporting;

    public RetryingRangeContentResponseHandler(Request request, Executor executor, boolean enableSentryReporting) {
        this.request = request;
        this.executor = executor;
        this.enableSentryReporting = enableSentryReporting;
    }

    public RetryingRangeContentResponseHandler(Request request, Executor executor) {
        this(request, executor, true);
    }

    public Content handleEntity(HttpEntity entity) throws IOException {
        if (entity == null) {
            return super.handleEntity(null);
        }
        long length = entity.getContentLength();
        InputStream content = entity.getContent();
        ByteArrayBuffer buffer = new ByteArrayBuffer(length > 0L ? (int)length : 4096);
        long read = this.readBuffer(content, buffer);
        if (length > 0L && read < length) {
            LOGGER.warn("Premature EOF while downloading {} ({} / {})", (Object)this.request, (Object)read, (Object)length);
            EntityUtils.consume((HttpEntity)entity);
            LOGGER.warn("Enabling retrying range download");
            int retryRequestCount = 0;
            while (read < length) {
                ++retryRequestCount;
                LOGGER.debug("Downloading range {}: {} / {}", (Object)this.request, (Object)read, (Object)length);
                RangeResponseHandler handler = new RangeResponseHandler(read, buffer);
                this.request.setHeader("Range", String.format(Locale.ROOT, "bytes=%d-%d", read, length));
                Response response = this.executor.execute(this.request);
                response.handleResponse((ResponseHandler)handler);
                read = handler.totalRead;
            }
            LOGGER.debug("Done range downloading {}: {} / {}", (Object)this.request, (Object)read, (Object)length);
            if (this.enableSentryReporting) {
                Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.WARNING).withMessage("partial download success").withExtra("request", (Object)this.request.toString()).withExtra("count", (Object)retryRequestCount).withExtra("length", (Object)length));
            }
        }
        return new Content(buffer.toByteArray(), ContentType.getOrDefault((HttpEntity)entity));
    }

    long readBuffer(InputStream content, ByteArrayBuffer buffer) throws IOException {
        int r;
        byte[] tmp = new byte[4096];
        long l = 0L;
        while ((r = content.read(tmp)) != -1) {
            buffer.append(tmp, 0, r);
            l += (long)r;
        }
        return l;
    }

    private class RangeResponseHandler
    extends AbstractResponseHandler<Void> {
        private final long start;
        private final ByteArrayBuffer buffer;
        long totalRead;

        RangeResponseHandler(long start, ByteArrayBuffer buffer) {
            this.start = start;
            this.buffer = buffer;
        }

        private void handle(HttpEntity entity) throws IOException {
            Objects.requireNonNull(entity, "entity");
            long read = RetryingRangeContentResponseHandler.this.readBuffer(entity.getContent(), this.buffer);
            this.totalRead = this.start + read;
        }

        public Void handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode == 200) {
                if (RetryingRangeContentResponseHandler.this.enableSentryReporting) {
                    Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("server doesn't seem to support partial downloads").withExtra("request", (Object)RetryingRangeContentResponseHandler.this.request.toString()).withExtra("response", (Object)response.toString()).withExtra("start", (Object)this.start).withExtra("totalRead", (Object)this.totalRead));
                }
                throw new HttpResponseException(200, "Expected partial download response");
            }
            if (statusCode != 206) {
                if (RetryingRangeContentResponseHandler.this.enableSentryReporting) {
                    Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withMessage("partial download failed: " + response.getStatusLine().toString()).withExtra("request", (Object)RetryingRangeContentResponseHandler.this.request.toString()).withExtra("response", (Object)response.toString()).withExtra("start", (Object)this.start).withExtra("totalRead", (Object)this.totalRead));
                }
                throw new HttpResponseException(statusCode, statusLine.getReasonPhrase());
            }
            return this.handleEntity(response.getEntity());
        }

        public Void handleEntity(HttpEntity entity) throws IOException {
            this.handle(entity);
            return null;
        }
    }
}

