/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.git;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import javax.annotation.Nonnull;
import ru.turikhay.util.git.ITokenResolver;

public class TokenReplacingReader
extends Reader {
    protected PushbackReader pushbackReader;
    protected ITokenResolver tokenResolver;
    protected final StringBuilder tokenNameBuffer = new StringBuilder();
    protected String tokenValue = null;
    protected int tokenValueIndex = 0;
    boolean unreadOnDollar;

    public TokenReplacingReader(Reader source, ITokenResolver resolver) {
        this.pushbackReader = new PushbackReader(source, 2);
        this.tokenResolver = resolver;
    }

    @Override
    public int read(@Nonnull CharBuffer target) throws IOException {
        int read;
        while ((read = this.read()) >= 0) {
            target.append((char)read);
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.tokenValue != null) {
            if (this.tokenValueIndex < this.tokenValue.length()) {
                return this.tokenValue.charAt(this.tokenValueIndex++);
            }
            if (this.tokenValueIndex == this.tokenValue.length()) {
                this.tokenValue = null;
                this.tokenValueIndex = 0;
            }
        }
        int data = this.pushbackReader.read();
        if (this.unreadOnDollar) {
            if (data == 65535) {
                data = -1;
            }
            this.unreadOnDollar = false;
            return data;
        }
        if (data != 36) {
            return data;
        }
        data = this.pushbackReader.read();
        if (data != 123) {
            this.unreadOnDollar = true;
            this.pushbackReader.unread(data);
            return 36;
        }
        this.tokenNameBuffer.delete(0, this.tokenNameBuffer.length());
        data = this.pushbackReader.read();
        while (data != 125) {
            this.tokenNameBuffer.append((char)data);
            data = this.pushbackReader.read();
        }
        this.tokenValue = this.tokenResolver.resolveToken(this.tokenNameBuffer.toString());
        if (this.tokenValue == null) {
            this.tokenValue = "${" + this.tokenNameBuffer + "}";
        }
        if (this.tokenValue.length() == 0) {
            return this.read();
        }
        return this.tokenValue.charAt(this.tokenValueIndex++);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead = 0;
        for (int i = 0; i < len; ++i) {
            int nextChar = this.read();
            if (nextChar == -1) {
                if (charsRead != 0) break;
                charsRead = -1;
                break;
            }
            charsRead = i + 1;
            cbuf[off + i] = (char)nextChar;
        }
        return charsRead;
    }

    @Override
    public void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public long skip(long n) {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public void reset() {
        throw new RuntimeException("Operation Not Supported");
    }

    public static String resolveVars(String str, ITokenResolver tokenResolver) {
        if (str == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TokenReplacingReader reader = new TokenReplacingReader(new StringReader(str), tokenResolver);
        try {
            int read;
            while ((read = reader.read()) != -1) {
                builder.append((char)read);
            }
        }
        catch (IOException ioE) {
            throw new Error(ioE);
        }
        return builder.toString();
    }
}

