/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import java.util.concurrent.atomic.AtomicBoolean;
import ru.turikhay.util.async.ExtendedThread;

public abstract class LoopedThread
extends ExtendedThread {
    protected static final String LOOPED_BLOCK = "iteration";
    private final AtomicBoolean working = new AtomicBoolean(true);

    public LoopedThread(String name) {
        super(name);
    }

    public LoopedThread() {
        this("LoopedThread");
    }

    @Override
    protected final void lockThread(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        if (!reason.equals(LOOPED_BLOCK)) {
            throw new IllegalArgumentException("Illegal block reason. Expected: iteration, got: " + reason);
        }
        super.lockThread(reason);
    }

    public final boolean isIterating() {
        return !this.isThreadLocked();
    }

    public void iterate() {
        if (!this.isIterating()) {
            this.unlockThread(LOOPED_BLOCK);
        }
    }

    @Override
    public final void run() {
        while (this.working.get()) {
            this.lockThread(LOOPED_BLOCK);
            this.iterateOnce();
        }
    }

    public final void dispose() {
        this.working.set(false);
        this.unlockThread(LOOPED_BLOCK);
    }

    protected abstract void iterateOnce();
}

