/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import java.util.concurrent.atomic.AtomicInteger;
import ru.turikhay.util.U;

public class ExtendedThread
extends Thread {
    private static final AtomicInteger threadNum = new AtomicInteger();
    private volatile ExtendedThreadCaller caller;
    private String blockReason;
    private final Object monitor = new Object();

    public ExtendedThread(Runnable runnable, String name) {
        super(runnable, (name == null ? "ExtendedThread" : name) + "#" + threadNum.incrementAndGet());
        this.caller = new ExtendedThreadCaller();
    }

    public ExtendedThread(Runnable runnable) {
        this(runnable, null);
    }

    public ExtendedThread(String name) {
        this((Runnable)null, name);
    }

    public ExtendedThread() {
        this((Runnable)null, (String)null);
    }

    public ExtendedThreadCaller getCaller() {
        return this.caller;
    }

    void setCaller(ExtendedThreadCaller caller) {
        this.caller = caller;
    }

    public void startAndWait() {
        super.start();
        while (!this.isThreadLocked()) {
            U.sleepFor(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockThread(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        this.checkCurrent();
        this.blockReason = reason;
        Object object = this.monitor;
        synchronized (object) {
            while (this.blockReason != null) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException var4) {
                    var4.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockThread(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        if (!reason.equals(this.blockReason)) {
            throw new IllegalStateException("Unlocking denied! Locked with: " + this.blockReason + ", tried to unlock with: " + reason);
        }
        this.blockReason = null;
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    public void tryUnlock(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        if (reason.equals(this.blockReason)) {
            this.unlockThread(reason);
        }
    }

    public boolean isThreadLocked() {
        return this.blockReason != null;
    }

    public boolean isCurrent() {
        return Thread.currentThread().equals(this);
    }

    protected void checkCurrent() {
        if (!this.isCurrent()) {
            throw new IllegalStateException("Illegal thread!");
        }
    }

    static class ExtendedThreadCaller
    extends RuntimeException {
        ExtendedThreadCaller() {
        }
    }
}

