/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.turikhay.util.async.ExtendedThread;

public class AsyncThread {
    public static final ExecutorService SHARED_SERVICE = Executors.newCachedThreadPool(ExtendedThread::new);
    public static final ScheduledExecutorService DELAYER = Executors.newSingleThreadScheduledExecutor();

    public static void execute(Runnable r) {
        SHARED_SERVICE.execute(AsyncThread.wrap(r));
    }

    public static void execute(Callable<Void> c) {
        SHARED_SERVICE.submit(c);
    }

    public static Future<?> future(Runnable r) {
        return SHARED_SERVICE.submit(AsyncThread.wrap(r));
    }

    public static <V> Future<V> future(Callable<V> c) {
        return SHARED_SERVICE.submit(AsyncThread.wrap(c));
    }

    public static <V> CompletableFuture<V> completableFuture(Callable<V> c) {
        CompletableFuture f = new CompletableFuture();
        AsyncThread.execute(() -> {
            Object v;
            try {
                v = c.call();
            }
            catch (Throwable t) {
                f.completeExceptionally(t);
                return;
            }
            f.complete(v);
        });
        return f;
    }

    public static Future<?> after(long timeout, TimeUnit timeUnit, Runnable r) {
        return DELAYER.schedule(r, timeout, timeUnit);
    }

    public static Future<?> afterSeconds(long timeout, Runnable r) {
        return AsyncThread.after(timeout, TimeUnit.SECONDS, r);
    }

    private static Runnable wrap(Runnable r) {
        ExtendedThread.ExtendedThreadCaller caller = new ExtendedThread.ExtendedThreadCaller();
        return () -> {
            AsyncThread.setupCaller(caller);
            r.run();
        };
    }

    private static <V> Callable<V> wrap(Callable<V> c) {
        ExtendedThread.ExtendedThreadCaller caller = new ExtendedThread.ExtendedThreadCaller();
        return () -> {
            AsyncThread.setupCaller(caller);
            return c.call();
        };
    }

    private static void setupCaller(ExtendedThread.ExtendedThreadCaller caller) {
        if (Thread.currentThread() instanceof ExtendedThread) {
            ((ExtendedThread)Thread.currentThread()).setCaller(caller);
        }
    }
}

