/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.turikhay.util.async.AsyncContainerLockedException;
import ru.turikhay.util.async.AsyncObject;
import ru.turikhay.util.async.AsyncObjectGotErrorException;
import ru.turikhay.util.async.AsyncObjectNotReadyException;

public class AsyncObjectContainer<T> {
    private final List<AsyncObject<T>> objects = new ArrayList<AsyncObject<T>>();
    private final Map<AsyncObject<T>, T> values = new LinkedHashMap<AsyncObject<T>, T>();
    private final Object waitLock = new Object();
    private boolean executionLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AsyncObject<T>, T> execute() {
        this.executionLock = true;
        this.values.clear();
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            boolean hasRemaining;
            for (AsyncObject<T> object : this.objects) {
                object.start();
            }
            do {
                hasRemaining = false;
                for (AsyncObject<T> object : this.objects) {
                    try {
                        if (this.values.containsKey(object)) continue;
                        this.values.put(object, object.getValue());
                    }
                    catch (AsyncObjectNotReadyException ignored) {
                        hasRemaining = true;
                    }
                    catch (AsyncObjectGotErrorException ignored0) {
                        this.values.put(object, null);
                    }
                }
                if (!hasRemaining) continue;
                Object object = this.waitLock;
                synchronized (object) {
                    try {
                        this.waitLock.wait();
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
            } while (hasRemaining);
        }
        this.executionLock = false;
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object.getContainer() != null) {
            throw new IllegalArgumentException();
        }
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.add(object);
            object.setContainer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object.getContainer() != this) {
            return;
        }
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }
}

