/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import ru.turikhay.util.async.AsyncObjectContainer;
import ru.turikhay.util.async.AsyncObjectGotErrorException;
import ru.turikhay.util.async.AsyncObjectNotReadyException;
import ru.turikhay.util.async.ExtendedThread;

public abstract class AsyncObject<E>
extends ExtendedThread {
    private AsyncObjectContainer<E> container;
    private boolean gotValue;
    private E value;
    private AsyncObjectGotErrorException error;

    protected AsyncObject() {
        super("AsyncObject");
    }

    public final AsyncObjectContainer<E> getContainer() {
        return this.container;
    }

    void setContainer(AsyncObjectContainer<E> container) {
        this.container = container;
    }

    @Override
    public void run() {
        try {
            this.value = this.execute();
        }
        catch (Throwable e) {
            this.error = new AsyncObjectGotErrorException(this, e);
        }
        this.gotValue = true;
        if (this.container != null) {
            this.container.release();
        }
    }

    public E getValue() throws AsyncObjectNotReadyException, AsyncObjectGotErrorException {
        if (this.error != null) {
            throw this.error;
        }
        if (!this.gotValue) {
            throw new AsyncObjectNotReadyException();
        }
        return this.value;
    }

    public AsyncObjectGotErrorException getError() {
        return this.error;
    }

    protected abstract E execute() throws AsyncObjectGotErrorException;
}

