/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import com.github.zafarkhaja.semver.Version;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.async.ExtendedThread;

public class U {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Lazy<Gson> gson = Lazy.of(() -> new GsonBuilder().create());

    private static String toLog(String prefix, Object ... append) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (prefix != null) {
            b.append(prefix);
            first = false;
        }
        if (append != null) {
            for (Object e : append) {
                if (e != null) {
                    if (e.getClass().isArray()) {
                        if (!first) {
                            b.append(" ");
                        }
                        if (e instanceof Object[]) {
                            b.append(U.toLog((Object[])e));
                            continue;
                        }
                        b.append(U.arrayToLog(e));
                        continue;
                    }
                    if (e instanceof Throwable) {
                        if (!first) {
                            b.append("\n");
                        }
                        b.append((CharSequence)U.stackTrace((Throwable)e));
                        b.append("\n");
                        continue;
                    }
                    if (e instanceof File) {
                        if (!first) {
                            b.append(" ");
                        }
                        File en = (File)e;
                        String absPath = en.getAbsolutePath();
                        b.append(absPath);
                        if (en.isDirectory() && !absPath.endsWith(File.separator)) {
                            b.append(File.separator);
                        }
                    } else if (e instanceof Iterator) {
                        Iterator var10 = (Iterator)e;
                        while (var10.hasNext()) {
                            b.append(" ");
                            b.append(U.toLog(var10.next()));
                        }
                    } else if (e instanceof Enumeration) {
                        Enumeration var11 = (Enumeration)e;
                        while (var11.hasMoreElements()) {
                            b.append(" ");
                            b.append(U.toLog(var11.nextElement()));
                        }
                    } else {
                        if (!first) {
                            b.append(" ");
                        }
                        b.append(e);
                    }
                } else {
                    if (!first) {
                        b.append(" ");
                    }
                    b.append("null");
                }
                if (!first) continue;
                first = false;
            }
        } else {
            b.append("null");
        }
        return b.toString();
    }

    public static String toLog(Object ... append) {
        return U.toLog(null, append);
    }

    private static String arrayToLog(Object e) {
        if (!e.getClass().isArray()) {
            throw new IllegalArgumentException("Given object is not an array!");
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (e instanceof Object[]) {
            for (Object i : (Object[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof int[]) {
            for (int var8 : (int[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var8);
            }
        } else if (e instanceof boolean[]) {
            for (boolean var9 : (boolean[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var9);
            }
        } else if (e instanceof long[]) {
            for (long var10 : (long[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var10);
            }
        } else if (e instanceof float[]) {
            for (float var11 : (float[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var11);
            }
        } else if (e instanceof double[]) {
            for (double var12 : (double[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var12);
            }
        } else if (e instanceof byte[]) {
            for (byte var13 : (byte[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var13);
            }
        } else if (e instanceof short[]) {
            for (short var14 : (short[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var14);
            }
        } else if (e instanceof char[]) {
            for (char var15 : (char[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var15);
            }
        }
        if (b.length() == 0) {
            throw new UnknownError("Unknown array type given.");
        }
        return b.toString();
    }

    public static double getAverage(double[] d, int max) {
        double a = 0.0;
        int k = 0;
        for (double curd : d) {
            a += curd;
            if (++k == max) break;
        }
        if (k == 0) {
            return 0.0;
        }
        return a / (double)k;
    }

    public static int getMaxMultiply(int i, int max) {
        if (i <= max) {
            return 1;
        }
        for (int x = max; x > 1; --x) {
            if (i % x != 0) continue;
            return x;
        }
        return (int)Math.ceil(i / max);
    }

    public static StringBuilder stackTrace(Throwable e) {
        StringBuilder trace = U.rawStackTrace(e);
        Thread thread = Thread.currentThread();
        if (thread instanceof ExtendedThread) {
            trace.append("\nThread called by: ").append((CharSequence)U.rawStackTrace(((ExtendedThread)thread).getCaller()));
        }
        return trace;
    }

    private static StringBuilder rawStackTrace(Throwable e) {
        Throwable var11;
        if (e == null) {
            return null;
        }
        StackTraceElement[] elems = e.getStackTrace();
        int programElements = 0;
        int totalElements = 0;
        StringBuilder builder = new StringBuilder();
        builder.append(e);
        for (StackTraceElement cause : elems) {
            ++totalElements;
            String description = cause.toString();
            if (description.startsWith("ru.turikhay")) {
                ++programElements;
            }
            builder.append("\nat ").append(description);
            if (totalElements != 100 && programElements != 50) continue;
            int remain = elems.length - totalElements;
            if (remain == 0) break;
            builder.append("\n... and ").append(remain).append(" more");
            break;
        }
        if ((var11 = e.getCause()) != null) {
            builder.append("\nCaused by: ").append((CharSequence)U.rawStackTrace(var11));
        }
        return builder;
    }

    public static long getUsingSpace() {
        return U.getTotalSpace() - U.getFreeSpace();
    }

    public static long getFreeSpace() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public static long getTotalSpace() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static String memoryStatus() {
        return U.getUsingSpace() + " / " + U.getTotalSpace() + " MB";
    }

    public static void sleepFor(long millis, boolean throwIfInterrupted) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            if (throwIfInterrupted) {
                throw new RuntimeException(e);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleepFor(long millis) {
        U.sleepFor(millis, true);
    }

    public static URL makeURL(String p, boolean assertValid) {
        try {
            return new URL(p);
        }
        catch (MalformedURLException e) {
            if (assertValid) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    public static URL makeURL(String p) {
        return U.makeURL(p, false);
    }

    public static int clamp(int val, int min, int max) {
        return Math.min(max, Math.max(val, min));
    }

    public static int getReadTimeout() {
        return U.getConnectionTimeout();
    }

    public static int getConnectionTimeout() {
        return 15000;
    }

    public static Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public static <T> T getRandom(List<? extends T> col) {
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.size() == 1 ? col.get(0) : col.get(ThreadLocalRandom.current().nextInt(col.size()));
    }

    public static <K, E> Map<K, E> sortMap(Map<K, E> map, K[] sortedKeys) {
        if (map == null) {
            return null;
        }
        if (sortedKeys == null) {
            throw new NullPointerException("Keys cannot be NULL!");
        }
        LinkedHashMap<K, E> result = new LinkedHashMap<K, E>();
        block0: for (K key : sortedKeys) {
            for (Map.Entry<K, E> entry : map.entrySet()) {
                K entryKey = entry.getKey();
                E value = entry.getValue();
                if (key == null && entryKey == null) {
                    result.put(null, value);
                    continue block0;
                }
                if (key == null || !key.equals(entryKey)) continue;
                result.put(key, value);
                continue block0;
            }
        }
        return result;
    }

    public static Color shiftColor(Color color, int bits, int min, int max) {
        if (color == null) {
            return null;
        }
        if (bits == 0) {
            return color;
        }
        int newRed = U.clamp(color.getRed() + bits, min, max);
        int newGreen = U.clamp(color.getGreen() + bits, min, max);
        int newBlue = U.clamp(color.getBlue() + bits, min, max);
        return new Color(newRed, newGreen, newBlue, color.getAlpha());
    }

    public static Color shiftColor(Color color, int bits) {
        return U.shiftColor(color, bits, 0, 255);
    }

    public static Color shiftAlpha(Color color, int bits, int min, int max) {
        if (color == null) {
            return null;
        }
        if (bits == 0) {
            return color;
        }
        int newAlpha = U.clamp(color.getAlpha() + bits, min, max);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), newAlpha);
    }

    public static Color shiftAlpha(Color color, int bits) {
        return U.shiftAlpha(color, bits, 0, 255);
    }

    public static Locale getLocale(String tag) {
        if (tag == null) {
            return null;
        }
        try {
            return LocaleUtils.toLocale((String)tag);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Couldn't parse locale: {}", (Object)tag, (Object)e);
            return null;
        }
    }

    public static Calendar getUTC() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public static Calendar getUTC(long millis) {
        Calendar date = U.getUTC();
        date.setTimeInMillis(millis);
        return date;
    }

    public static String getNormalVersion(Version version) {
        return String.format(Locale.ROOT, "%d.%d.%d", version.getMajorVersion(), version.getMinorVersion(), version.getPatchVersion());
    }

    public static String getFormattedVersion(Version version) {
        StringBuilder sb = new StringBuilder(U.getNormalVersion(version));
        if (!version.getPreReleaseVersion().isEmpty()) {
            sb.append("-").append(version.getPreReleaseVersion());
        }
        if (!version.getBuildMetadata().isEmpty()) {
            sb.append("+").append(version.getBuildMetadata());
        }
        return sb.toString();
    }

    public static String getMinorVersion(Version version) {
        return String.format(Locale.ROOT, "%s%d.%d", version.getMajorVersion() == 1 ? "" : version.getMajorVersion() + ".", version.getMinorVersion(), version.getPatchVersion());
    }

    public static String parseHost(String url) {
        if (url == null) {
            return null;
        }
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Gson getGson() {
        return gson.get();
    }
}

