/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public final class Time {
    private static final ArrayList<TimeHolder> holders = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T start(T object) {
        ArrayList<TimeHolder> arrayList = holders;
        synchronized (arrayList) {
            Iterator<TimeHolder> i = holders.iterator();
            while (i.hasNext()) {
                TimeHolder holder = i.next();
                switch (holder.isHolding(object)) {
                    case TRUE: {
                        throw new IllegalStateException("object is already being held");
                    }
                    case UNDEFINED: {
                        i.remove();
                    }
                }
            }
            holders.add(new TimeHolder(object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long stop(Object object, long currentTime) {
        ArrayList<TimeHolder> arrayList = holders;
        synchronized (arrayList) {
            Iterator<TimeHolder> i = holders.iterator();
            while (i.hasNext()) {
                TimeHolder holder = i.next();
                if (holder.isHolding(object) != NotBoolean.TRUE) continue;
                long delta = currentTime - holder.timestamp;
                i.remove();
                return delta;
            }
        }
        return Long.MIN_VALUE;
    }

    public static long stop(Object object) {
        return Time.stop(object, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] stop(Object ... object) {
        long currentTime = System.currentTimeMillis();
        long[] deltas = new long[object.length];
        ArrayList<TimeHolder> arrayList = holders;
        synchronized (arrayList) {
            for (int i = 0; i < object.length; ++i) {
                deltas[i] = Time.stop(object[i], currentTime);
            }
        }
        return deltas;
    }

    public static void start() {
        Time.start(Thread.currentThread());
    }

    public static long stop() {
        return Time.stop((Object)Thread.currentThread());
    }

    private Time() {
    }

    private static class TimeHolder {
        private final WeakReference<Object> ref;
        private final long timestamp;

        TimeHolder(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            this.ref = new WeakReference<Object>(o);
            this.timestamp = System.currentTimeMillis();
        }

        NotBoolean isHolding(Object object) {
            Object o = this.ref.get();
            if (o == null) {
                return NotBoolean.UNDEFINED;
            }
            return o == object ? NotBoolean.TRUE : NotBoolean.FALSE;
        }
    }

    static enum NotBoolean {
        FALSE,
        TRUE,
        UNDEFINED;

    }
}

