/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.View;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.SwingException;
import ru.turikhay.util.SwingRunnable;
import ru.turikhay.util.SwingRunnableException;

public class SwingUtil {
    private static final Logger LOGGER = LogManager.getLogger(SwingUtil.class);
    private static final Lazy<List<Image>> favicons = Lazy.of(() -> SwingUtil.createFaviconList("logo-tl"));
    private static final String base64s = "data:image/";
    private static final String base64e = ";base64,";
    private static final Lazy<Double> SCALING_FACTOR = Lazy.of(SwingUtil::queryScalingFactor);

    public static List<Image> createFaviconList(String iconName) {
        int[] sizes;
        ArrayList<Image> favicons = new ArrayList<Image>();
        for (int size : sizes = new int[]{256, 128, 96, 64, 48, 32, 24, 16}) {
            Image image = Images.loadIcon(iconName, size);
            if (image == null) continue;
            favicons.add(image);
        }
        return Collections.unmodifiableList(favicons);
    }

    public static List<Image> getFavicons() {
        return favicons.get();
    }

    public static void setFavicons(JFrame frame) {
        frame.setIconImages(SwingUtil.getFavicons());
    }

    public static void initFontSize(int defSize) {
        try {
            UIDefaults e = UIManager.getDefaults();
            int maxSize = defSize + 2;
            Enumeration e1 = e.keys();
            while (e1.hasMoreElements()) {
                Object key = e1.nextElement();
                Object value = e.get(key);
                if (!(value instanceof Font)) continue;
                Font font = (Font)value;
                int size = font.getSize();
                if (size < defSize) {
                    size = defSize;
                } else if (size > maxSize) {
                    size = maxSize;
                }
                if (value instanceof FontUIResource) {
                    e.put(key, new FontUIResource(font.getName(), font.getStyle(), size));
                    continue;
                }
                e.put(key, new Font(font.getName(), font.getStyle(), size));
            }
        }
        catch (Exception var9) {
            LOGGER.warn("Cannot change font size", (Throwable)var9);
        }
    }

    public static Cursor getCursor(int type) {
        try {
            return Cursor.getPredefinedCursor(type);
        }
        catch (IllegalArgumentException var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static void setFontSize(JComponent comp, float size) {
        comp.setFont(comp.getFont().deriveFont(size));
    }

    public static int magnify(int i) {
        return (int)Math.rint((double)i * TLauncherFrame.magnifyDimensions);
    }

    public static float magnify(float i) {
        return (float)((double)i * TLauncherFrame.magnifyDimensions);
    }

    public static Dimension magnify(Dimension d) {
        return new Dimension(SwingUtil.magnify(d.width), SwingUtil.magnify(d.height));
    }

    public static Insets magnify(Insets i) {
        i.top = SwingUtil.magnify(i.top);
        i.left = SwingUtil.magnify(i.left);
        i.bottom = SwingUtil.magnify(i.bottom);
        i.right = SwingUtil.magnify(i.right);
        return i;
    }

    public static Dimension getPrefSize(JComponent component, int width, int height) {
        View view;
        Objects.requireNonNull(component, "component");
        if (component instanceof JLabel) {
            view = (View)component.getClientProperty("html");
        } else if (component instanceof JEditorPane) {
            view = ((JEditorPane)component).getUI().getRootView((JEditorPane)component);
        } else {
            throw new IllegalArgumentException();
        }
        view.setSize(width, height);
        return new Dimension((int)Math.ceil(view.getPreferredSpan(0)), (int)Math.ceil(view.getPreferredSpan(1)));
    }

    public static int getPrefWidth(JComponent component, int height, int step) {
        int curHeight;
        int minHeight = SwingUtil.getPrefHeight(component, Integer.MAX_VALUE);
        int width = 0;
        while ((curHeight = SwingUtil.getPrefHeight(component, width += step)) >= height && curHeight != minHeight) {
        }
        return width;
    }

    public static int getPrefHeight(JComponent component, int width) {
        return SwingUtil.getPrefSize((JComponent)component, (int)width, (int)0).height;
    }

    public static BufferedImage base64ToImage(String source) throws IOException {
        if (!source.startsWith(base64s)) {
            throw new IllegalArgumentException("not a bse64 format");
        }
        int offset = base64s.length();
        if (source.startsWith("png", offset) || source.startsWith("jpg", offset) || source.startsWith("gif")) {
            offset += 3;
        } else if (source.startsWith("jpeg", offset)) {
            offset += 4;
        } else {
            return null;
        }
        if (!source.startsWith(base64e, offset)) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(source.substring(offset += base64e.length()).getBytes(StandardCharsets.UTF_8))));
    }

    public static Image loadImage(String source) throws IOException {
        try {
            return SwingUtil.base64ToImage(source);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return ImageIO.read(new URL(source));
            }
            catch (MalformedURLException malformedURLException) {
                return Images.loadIconById(source);
            }
        }
    }

    public static void later(SwingRunnable r) {
        EventQueue.invokeLater(r);
    }

    public static void laterRunnable(Runnable r) {
        SwingUtil.later(r::run);
    }

    public static void wait(SwingRunnable r) {
        if (EventQueue.isDispatchThread()) {
            SwingUtil.invokeNow(r);
        } else {
            SwingUtil.invokeAndWait(r);
        }
    }

    public static <V> V waitAndReturn(Callable<V> callable) {
        AtomicReference ref = new AtomicReference();
        SwingUtil.wait(() -> ref.set(callable.call()));
        return ref.get();
    }

    private static void invokeNow(SwingRunnable r) {
        try {
            r.run();
        }
        catch (SwingRunnableException e) {
            throw new SwingException(e.getCause());
        }
    }

    private static void invokeAndWait(SwingRunnable r) {
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable t;
            if (invocationTargetException.getCause() != null) {
                t = invocationTargetException.getCause();
                if (t instanceof SwingRunnableException) {
                    t = t.getCause();
                }
            } else {
                t = invocationTargetException;
            }
            throw new SwingException(t);
        }
    }

    public static double getScalingFactor() {
        return SCALING_FACTOR.value().orElse(1.0);
    }

    private static double queryScalingFactor() throws Exception {
        try {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfig = graphicsDevice.getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            double scaleX = tx.getScaleX();
            double scaleY = tx.getScaleY();
            return Math.max(scaleX, scaleY);
        }
        catch (NoClassDefFoundError | NoSuchMethodError t) {
            throw new Exception(t);
        }
    }
}

