/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.exceptions.ParseException;

public class StringUtil {
    public static boolean parseBoolean(String b) throws ParseException {
        if (b == null) {
            throw new ParseException("String cannot be NULL!");
        }
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        if (b.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParseException("Cannot parse value (" + b + ")!");
    }

    public static String cut(String string, int max) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len <= max) {
            return string;
        }
        String[] words = string.split(" ");
        StringBuilder ret = new StringBuilder();
        int remaining = max + 1;
        for (int x = 0; x < words.length; ++x) {
            String curword = words[x];
            int curlen = curword.length();
            if (curlen >= remaining) {
                if (x != 0) break;
                ret.append(" ").append(curword, 0, remaining - 1);
                break;
            }
            ret.append(" ").append(curword);
            remaining -= curlen + 1;
        }
        return ret.length() == 0 ? "" : ret.substring(1) + "...";
    }

    public static String requireNotBlank(String s, String name) {
        if (s == null) {
            throw new NullPointerException(name);
        }
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new IllegalArgumentException(name);
        }
        return s;
    }

    public static String requireNotBlank(String s) {
        return StringUtil.requireNotBlank(s, null);
    }
}

