/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import ru.turikhay.util.CharsetData;

public class StringCharsetData
implements CharsetData {
    private static final int PRETTY_LONG_STRING = 524288;
    private static final int LENGTH_TOO_LONG = Integer.MIN_VALUE;
    private final String string;
    private int size = -2;

    public StringCharsetData(String string) {
        this.string = Objects.requireNonNull(string, "string");
    }

    @Override
    public StringReader read() {
        return new StringReader(this.string);
    }

    @Override
    public InputStream stream() {
        return new ByteArrayInputStream(this.string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public long length() {
        if (this.size == -1) {
            this.size = this.string.length() > 524288 ? Integer.MIN_VALUE : this.string.getBytes(StandardCharsets.UTF_8).length;
        }
        return this.size == Integer.MIN_VALUE ? -1L : (long)this.size;
    }
}

