/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.jna.JNA;
import ru.turikhay.tlauncher.jna.JNAMacOs;
import ru.turikhay.tlauncher.portals.Portals;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.util.JavaVersion;

public final class OS
extends Enum<OS> {
    public static final /* enum */ OS LINUX;
    public static final /* enum */ OS WINDOWS;
    public static final /* enum */ OS OSX;
    public static final /* enum */ OS UNKNOWN;
    private static final Logger LOGGER;
    public static final String NAME;
    public static final String VERSION;
    public static final OS CURRENT;
    public static final JavaVersion JAVA_VERSION;
    private final String[] aliases;
    private static final /* synthetic */ OS[] $VALUES;

    public static OS[] values() {
        return (OS[])$VALUES.clone();
    }

    public static OS valueOf(String name) {
        return Enum.valueOf(OS.class, name);
    }

    private OS(String ... aliases) {
        this.aliases = aliases;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isUnsupported() {
        return this == UNKNOWN;
    }

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public static boolean is(OS ... any) {
        if (any == null) {
            throw new NullPointerException();
        }
        if (any.length == 0) {
            return false;
        }
        for (OS compare : any) {
            if (CURRENT != compare) continue;
            return true;
        }
        return false;
    }

    private static OS detectOSFallback() {
        String osName = NAME.toLowerCase(Locale.ROOT);
        for (OS os : OS.values()) {
            for (String alias : os.aliases) {
                if (!osName.contains(alias)) continue;
                return os;
            }
        }
        return UNKNOWN;
    }

    public static String getJavaPath(boolean appendBinFolder) {
        char separator = File.separatorChar;
        String path = System.getProperty("java.home") + separator;
        if (appendBinFolder) {
            path = path + "bin" + separator + "java";
            if (CURRENT == WINDOWS) {
                path = path + "w.exe";
            }
        }
        return path;
    }

    public static String getJavaPath() {
        return OS.getJavaPath(true);
    }

    public static String getSummary() {
        return String.format(Locale.ROOT, "%s (%s) %s, Java %s %s (%s), %s MB RAM, %sx CPU", new Object[]{NAME, VERSION, JNA.getArch().orElse("n/a"), System.getProperty("java.version", "unknown"), System.getProperty("os.arch", "unknown"), Arch.CURRENT, Arch.TOTAL_RAM_MB, Arch.AVAILABLE_PROCESSORS});
    }

    public static boolean openLink(String _url, boolean alertError) {
        URL url;
        try {
            url = new URL(_url);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse link: \"{}\"", (Object)_url, (Object)e);
            if (alertError) {
                Alert.showLocError("ui.error.openlink", _url);
            }
            return false;
        }
        return OS.openLink(url);
    }

    public static boolean openLink(String url) {
        return OS.openLink(url, true);
    }

    public static boolean openLink(URI uri, boolean alertError) {
        if (Portals.getPortal().openURI(uri)) {
            return true;
        }
        LOGGER.log(alertError ? Level.ERROR : Level.WARN, "Opening the link failed: \"{}\"", (Object)uri);
        if (alertError) {
            Alert.showLocError("ui.error.openlink", uri);
        }
        return false;
    }

    public static boolean openLink(URI uri) {
        return OS.openLink(uri, true);
    }

    public static boolean openLink(URL url, boolean alertError) {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (Exception var4) {
            LOGGER.warn("Couldn't convert URL to URI: {}", (Object)url, (Object)var4);
        }
        return OS.openLink(uri, alertError);
    }

    public static boolean openLink(URL url) {
        return OS.openLink(url, true);
    }

    public static boolean openFolder(File folder, boolean alertError) {
        LOGGER.info("Trying to open folder: {}", (Object)folder);
        if (!folder.isDirectory()) {
            LOGGER.warn("This path is not a directory, sorry.");
            return false;
        }
        try {
            return Portals.getPortal().openFile(folder.toPath());
        }
        catch (Throwable var3) {
            LOGGER.log(alertError ? Level.ERROR : Level.WARN, "Failed to open folder: {}", (Object)folder, (Object)var3);
            if (alertError) {
                Alert.showLocError("ui.error.openfolder", folder);
            }
            return false;
        }
    }

    public static boolean openFolder(File folder) {
        return OS.openFolder(folder, true);
    }

    public static boolean openFile(File file, boolean alertError) {
        LOGGER.info("Trying to open file: {}", (Object)file);
        if (!file.isFile()) {
            LOGGER.warn("This path is not a file, sorry.");
            return false;
        }
        try {
            return Portals.getPortal().openFile(file.toPath());
        }
        catch (Throwable var3) {
            LOGGER.log(alertError ? Level.ERROR : Level.WARN, "Failed to open file: {}", (Object)file, (Object)var3);
            if (alertError) {
                Alert.showLocError("ui.error.openfolder", file);
            }
            return false;
        }
    }

    public static boolean openFile(File file) {
        return OS.openFile(file, true);
    }

    private static /* synthetic */ OS[] $values() {
        return new OS[]{LINUX, WINDOWS, OSX, UNKNOWN};
    }

    static {
        JavaVersion version;
        LINUX = new OS("linux", "unix");
        WINDOWS = new OS("win");
        OSX = new OS("mac");
        UNKNOWN = new OS("unknown");
        $VALUES = OS.$values();
        LOGGER = LogManager.getLogger(OS.class);
        NAME = System.getProperty("os.name");
        VERSION = System.getProperty("os.version");
        CURRENT = JNA.getCurrentOs().orElseGet(OS::detectOSFallback);
        try {
            version = JavaVersion.parse(System.getProperty("java.version"));
        }
        catch (Exception e) {
            version = JavaVersion.create(1, 8, 0, 45);
            LOGGER.warn("Could not parse Java version: {}", (Object)System.getProperty("java.version"));
            LOGGER.warn("Assuming it is 1.8.0_45");
        }
        JAVA_VERSION = version;
    }

    public static enum Arch {
        x86,
        x64,
        ARM,
        ARM64;

        public static final Arch CURRENT;
        public static final boolean IS_64_BIT;
        public static final long TOTAL_RAM;
        public static final long TOTAL_RAM_MB;
        public static final int AVAILABLE_PROCESSORS;

        public boolean isCurrent() {
            return this == CURRENT;
        }

        public boolean isARM() {
            return this == ARM || this == ARM64;
        }

        public boolean is64Bit() {
            return this == x64 || this == ARM64;
        }

        private static long getTotalRam() {
            try {
                return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
            }
            catch (Throwable var1) {
                LOGGER.warn("Cannot query total physical memory size!", var1);
                return 0L;
            }
        }

        private static int getAvailableProcessors() {
            try {
                return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            }
            catch (Throwable var1) {
                LOGGER.warn("Cannot query the number of available processors", var1);
                return 1;
            }
        }

        private static boolean is64BitFallback() {
            String model = System.getProperty("sun.arch.data.model");
            if (model != null) {
                return "64".equals(model);
            }
            String arch = System.getProperty("os.arch");
            if (arch != null) {
                return arch.contains("64");
            }
            return false;
        }

        static {
            IS_64_BIT = JNA.is64Bit().orElseGet(Arch::is64BitFallback);
            boolean isMacOsARM = OSX.isCurrent() && IS_64_BIT ? JNA.isARM().orElse(false) != false || JNAMacOs.isUnderRosetta().orElse(false) != false : false;
            Arch current = isMacOsARM ? ARM64 : (IS_64_BIT ? x64 : x86);
            CURRENT = current;
            TOTAL_RAM = Arch.getTotalRam();
            TOTAL_RAM_MB = TOTAL_RAM / 1024L / 1024L;
            AVAILABLE_PROCESSORS = Arch.getAvailableProcessors();
        }
    }
}

