/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;

public class MinecraftUtil {
    private static final Logger LOGGER = LogManager.getLogger(MinecraftUtil.class);
    private static FileExplorer explorer;
    private static JFrame parent;

    private static boolean checkDirectory(File directory) {
        return directory.isDirectory() && directory.canRead() && directory.canWrite();
    }

    private static File chooseWorkingDir(String path) {
        File preferredDirectory;
        File directory = new File(path);
        if (MinecraftUtil.checkDirectory(directory)) {
            return directory;
        }
        try {
            FileUtil.createFolder(directory);
            if (MinecraftUtil.checkDirectory(directory)) {
                return directory;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Got error trying to create directory", (Throwable)e);
        }
        File defaultDirectory = MinecraftUtil.getDefaultWorkingDirectory();
        try {
            FileUtil.createFolder(defaultDirectory);
            preferredDirectory = defaultDirectory;
        }
        catch (IOException e) {
            LOGGER.warn("Can't even create default folder", (Throwable)e);
            preferredDirectory = new File(System.getProperty("user.home", "/"));
        }
        do {
            LOGGER.info("Current directory cannot be written to: {}", (Object)directory);
            Alert.showLocError("version.dir.noaccess", directory);
            directory = MinecraftUtil.showExplorer(preferredDirectory);
            if (directory == null) {
                LOGGER.info("No directory selected, killing launcher. Good bye!");
                System.exit(0);
            }
            LOGGER.info("User selected directory: {}", (Object)directory);
        } while (!MinecraftUtil.checkDirectory(directory));
        if (defaultDirectory != directory && defaultDirectory.isDirectory() && defaultDirectory.length() == 0L) {
            LOGGER.info("Default game folder is exists, is empty and is not used. Deleting");
            defaultDirectory.delete();
        }
        return directory;
    }

    public static File getWorkingDirectory(boolean choose) {
        File defaultDirectory = MinecraftUtil.getDefaultWorkingDirectory();
        if (TLauncher.getInstance() == null) {
            return defaultDirectory;
        }
        String path = TLauncher.getInstance().getSettings().get("minecraft.gamedir");
        if (path == null) {
            return defaultDirectory;
        }
        return choose ? MinecraftUtil.chooseWorkingDir(path) : new File(path);
    }

    public static File getWorkingDirectory() {
        return MinecraftUtil.getWorkingDirectory(true);
    }

    private static File showExplorer(File preferred) {
        if (explorer == null) {
            parent = new JFrame();
            try {
                explorer = FileExplorer.newExplorer();
                explorer.setSelectedFile(preferred);
                explorer.setFileSelectionMode(1);
            }
            catch (Exception e) {
                String answer = Alert.showLocInputQuestion("version.dir.noexplorer");
                if (answer == null) {
                    return null;
                }
                return new File(answer);
            }
        }
        return explorer.showDialog(parent) != 0 ? null : explorer.getSelectedFile();
    }

    public static File getSystemRelatedFile(String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (OS.CURRENT) {
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case OSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static File getSystemRelatedDirectory(String path, boolean hide) {
        if (hide && !OS.is(OS.OSX, OS.UNKNOWN)) {
            path = '.' + path;
        }
        return MinecraftUtil.getSystemRelatedFile(path);
    }

    public static File getSystemRelatedDirectory(String path) {
        return MinecraftUtil.getSystemRelatedDirectory(path, true);
    }

    public static File getDefaultWorkingDirectory() {
        return MinecraftUtil.getSystemRelatedDirectory(TLauncher.getFolder());
    }

    public static File getOptionsFile() {
        return MinecraftUtil.getFile("options.txt");
    }

    private static File getFile(String name) {
        return new File(MinecraftUtil.getWorkingDirectory(), name);
    }
}

