/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.LazyInitException;

public final class Lazy<T>
implements Callable<T> {
    private static final Logger LOGGER = LogManager.getLogger(Lazy.class);
    private Callable<T> initializer;
    private boolean calledOnce;
    private Throwable exception;
    private T value;

    private Lazy(Callable<T> initializer) {
        this.initializer = initializer;
    }

    public boolean isInitialized() {
        return this.calledOnce;
    }

    public synchronized T get() throws LazyInitException {
        T value;
        if (this.exception != null) {
            throw new LazyInitException(this.exception);
        }
        if (this.calledOnce) {
            return this.value;
        }
        this.calledOnce = true;
        try {
            value = this.initializer.call();
        }
        catch (Exception e) {
            LOGGER.debug("Initialization exception on {}", this.initializer, (Object)e);
            this.exception = e;
            throw new LazyInitException(e);
        }
        catch (Throwable e) {
            LOGGER.warn("Severe initialization error on {}", this.initializer, (Object)e);
            this.exception = e;
            throw new LazyInitException(e);
        }
        finally {
            this.initializer = null;
        }
        this.value = value;
        return this.value;
    }

    @Override
    public T call() throws Exception {
        try {
            return this.get();
        }
        catch (LazyInitException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new Error(cause);
        }
    }

    public Optional<T> value() {
        T value;
        try {
            value = this.get();
        }
        catch (LazyInitException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    public Optional<T> valueIfInitialized() {
        if (this.isInitialized()) {
            return this.value();
        }
        return Optional.empty();
    }

    public static <T> Lazy<T> of(Callable<T> callable) {
        return new Lazy<T>(Objects.requireNonNull(callable));
    }

    public String toString() {
        return "Lazy{" + (this.calledOnce ? "value=" + this.value : "initializer=" + this.initializer) + '}';
    }
}

