/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.JavaVersion;
import ru.turikhay.util.JavaVersionNotDetectedException;
import ru.turikhay.util.async.AsyncThread;

public class JavaVersionDetector {
    private static final Pattern PATTERN = Pattern.compile("^\\$#! java: (.+)$");
    private static final Logger LOGGER = LogManager.getLogger(JavaVersionDetector.class);
    private final String javaExec;

    public JavaVersionDetector(String javaExec) {
        this.javaExec = javaExec;
    }

    public JavaVersion detect() throws JavaVersionNotDetectedException, InterruptedException {
        Future<JavaVersion> task = AsyncThread.future(this::doDetect);
        try {
            JavaVersion javaVersion = task.get(30L, TimeUnit.SECONDS);
            return javaVersion;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JavaVersionNotDetectedException) {
                throw (JavaVersionNotDetectedException)e.getCause();
            }
            throw new JavaVersionNotDetectedException(e);
        }
        catch (TimeoutException e) {
            throw new JavaVersionNotDetectedException(e);
        }
        finally {
            task.cancel(true);
        }
    }

    /*
     * Exception decompiling
     */
    private JavaVersion doDetect() throws JavaVersionNotDetectedException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

