/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaVersion
implements Comparable<JavaVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaVersion.class);
    public static final JavaVersion UNKNOWN = new JavaVersion("unknown", "unknown", 1, 0, 0, 0);
    private static JavaVersion CURRENT;
    private final String version;
    private final String identifier;
    private final int epoch;
    private final int major;
    private final int minor;
    private final int update;
    private final boolean ea;
    private final double d;
    private static final Pattern pattern;

    public static JavaVersion getCurrent() {
        if (CURRENT == null) {
            JavaVersion version;
            String sVersion = System.getProperty("java.version");
            try {
                version = JavaVersion.parse(sVersion);
            }
            catch (RuntimeException rE) {
                LOGGER.warn("Could not parse java version: {}", (Object)sVersion, (Object)rE);
                version = UNKNOWN;
            }
            CURRENT = version;
        }
        return CURRENT;
    }

    private JavaVersion(String version, String identifier, int epoch, int major, int minor, int update) {
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("version");
        }
        this.version = version;
        String string = identifier = StringUtils.isBlank((CharSequence)identifier) ? null : identifier;
        if (epoch == 1) {
            this.epoch = epoch;
            this.major = JavaVersion.ifNotNegative(major, "major");
            this.minor = JavaVersion.ifNotNegative(minor, "minor");
            if (identifier != null && update == 0) {
                update = -1;
                if (!identifier.equals("unknown")) {
                    if (identifier.startsWith("u")) {
                        update = JavaVersion.parse(identifier.substring(1), "update in identifier (starting with \"u\")");
                        identifier = null;
                    } else {
                        Integer updateInIdentifier = JavaVersion.asInteger(identifier);
                        if (updateInIdentifier != null) {
                            update = updateInIdentifier;
                            identifier = null;
                        }
                    }
                }
            }
            this.update = JavaVersion.ifNotSmallerMinusOne(update, "update");
        } else if (epoch == 0 && JavaVersion.ifPositive(major, "major") > 0) {
            this.epoch = 1;
            this.major = major;
            this.minor = JavaVersion.ifNotNegative(minor, "minor (java 9+)");
            this.update = JavaVersion.ifNotSmallerMinusOne(minor, "update (java 9+)");
        } else {
            this.epoch = 1;
            this.major = JavaVersion.ifPositive(epoch, "major (java 9+)");
            this.minor = JavaVersion.ifNotNegative(major, "minor (java 9+)");
            this.update = JavaVersion.ifNotSmallerMinusOne(minor, "update (java 9+)");
        }
        this.identifier = identifier;
        this.ea = version.contains("-ea");
        this.d = Double.parseDouble(this.epoch + "." + this.major);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + this.epoch;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.update;
        result = 31 * result + (this.ea ? 1 : 0);
        long temp = Double.doubleToLongBits(this.d);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int compareTo(JavaVersion o) {
        if (o == null) {
            throw new NullPointerException("version");
        }
        int epochCompare = Integer.compare(this.getEpoch(), o.getEpoch());
        if (epochCompare != 0) {
            return epochCompare;
        }
        int majorCompare = Integer.compare(this.getMajor(), o.getMajor());
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Integer.compare(this.getMinor(), o.getMinor());
        if (minorCompare != 0) {
            return minorCompare;
        }
        int updateCompare = Integer.compare(this.getUpdate(), o.getUpdate());
        if (updateCompare != 0) {
            return updateCompare;
        }
        return Boolean.compare(this.isRelease(), o.isRelease());
    }

    public String getVersion() {
        return this.version;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public double getDouble() {
        return this.d;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getUpdate() {
        return this.update;
    }

    public boolean isEarlyAccess() {
        return this.ea;
    }

    public boolean isRelease() {
        return this.identifier == null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("version", (Object)this.getVersion()).append("identifier", (Object)this.getIdentifier()).append("epoch", this.getEpoch()).append("major", this.getMajor()).append("minor", this.getMinor()).append("update", this.getUpdate()).append("ea", this.isEarlyAccess()).append("release", this.isRelease()).build();
    }

    public static JavaVersion create(int epoch, int major, int minor, int update) {
        return new JavaVersion(epoch + "." + major + "." + minor + (update > 0 ? "_" + update : ""), null, epoch, major, minor, update);
    }

    public static JavaVersion parse(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("version");
        }
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("could not parse java version");
        }
        if (matcher.groupCount() != 5) {
            throw new IllegalArgumentException("illegal group count: " + matcher.groupCount());
        }
        return new JavaVersion(version, matcher.group(5), JavaVersion.parse(matcher.group(1), "epoch", true), JavaVersion.parse(matcher.group(2), "major"), JavaVersion.parse(matcher.group(3), "minor", true), JavaVersion.parse(matcher.group(4), "update", true));
    }

    private static int parse(String str, String name, boolean zeroifNull) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            if (zeroifNull) {
                return 0;
            }
            throw new IllegalArgumentException("could not parse " + name, null);
        }
        try {
            return Integer.parseInt(str);
        }
        catch (RuntimeException rE) {
            throw new IllegalArgumentException("could not parse " + name, rE);
        }
    }

    private static int parse(String str, String name) {
        return JavaVersion.parse(str, name, false);
    }

    private static Integer asInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (RuntimeException rE) {
            return null;
        }
    }

    private static int ifPositive(int num, String name) {
        if (num <= 0) {
            throw new IllegalArgumentException(name + " must be positive");
        }
        return num;
    }

    private static int ifNotNegative(int num, String name) {
        if (num < 0) {
            throw new IllegalArgumentException(name + " must not be negative");
        }
        return num;
    }

    private static int ifNotSmallerMinusOne(int num, String name) {
        if (num < -1) {
            throw new IllegalArgumentException(name + " must not be less than -1");
        }
        return num;
    }

    static {
        pattern = Pattern.compile("(?:([0-9]+)\\.)?([0-9]+)(?:\\.([0-9]+))?(?:\\.[0-9]+)*(?:_([0-9]+)(?:b[0-9]+)?)?(?:-(.+))?");
    }
}

