/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.awt.Dimension;
import ru.turikhay.tlauncher.exceptions.ParseException;

public class IntegerArray {
    public static final char defaultDelimiter = ';';
    private final int[] integers;
    private final char delimiter;
    private final int length;

    public IntegerArray(char del, int ... values) {
        this.delimiter = del;
        this.length = values.length;
        this.integers = new int[this.length];
        System.arraycopy(values, 0, this.integers, 0, this.length);
    }

    public IntegerArray(int ... values) {
        this(';', values);
    }

    public int get(int pos) {
        if (pos >= 0 && pos < this.length) {
            return this.integers[pos];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid position (" + pos + " / " + this.length + ")!");
    }

    public void set(int pos, int val) {
        if (pos < 0 || pos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid position (" + pos + " / " + this.length + ")!");
        }
        this.integers[pos] = val;
    }

    public int size() {
        return this.length;
    }

    public int[] toArray() {
        return (int[])this.integers.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i : this.integers) {
            if (sb.length() != 0) {
                sb.append(this.delimiter);
            }
            sb.append(i);
        }
        return sb.toString();
    }

    public static IntegerArray parseIntegerArray(String val, char del) throws ParseException {
        if (val == null) {
            throw new ParseException("String cannot be NULL!");
        }
        if (val.length() <= 1) {
            throw new ParseException("String mustn't equal or be less than delimiter!");
        }
        String regexp = "(?<!\\\\)";
        if (del != 'x') {
            regexp = regexp + "\\";
        }
        regexp = regexp + del;
        String[] ints = val.split(regexp);
        int l = ints.length;
        int[] arr = new int[l];
        for (int i = 0; i < l; ++i) {
            int cur;
            try {
                cur = Integer.parseInt(ints[i]);
            }
            catch (NumberFormatException var9) {
                throw new ParseException("Cannot parse integer (iteration: " + i + ", del: \"" + del + "\")", var9);
            }
            arr[i] = cur;
        }
        return new IntegerArray(del, arr);
    }

    public static IntegerArray parseIntegerArray(String val) throws ParseException {
        return IntegerArray.parseIntegerArray(val, ';');
    }

    private static int[] toArray(String val, char del) throws ParseException {
        IntegerArray arr = IntegerArray.parseIntegerArray(val, del);
        return arr.toArray();
    }

    public static int[] toArray(String val) throws ParseException {
        return IntegerArray.toArray(val, ';');
    }

    public static IntegerArray fromDimension(Dimension d) {
        return new IntegerArray('x', d.width, d.height);
    }
}

