/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static final Logger LOGGER = LogManager.getLogger(FileUtil.class);
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static Charset getCharset() {
        try {
            return Charset.forName(DEFAULT_CHARSET);
        }
        catch (Exception var1) {
            throw new Error("UTF-8 is not supported", var1);
        }
    }

    public static void writeFile(File file, String text) throws IOException {
        FileUtil.createFile(file);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
        ow.write(text);
        ow.close();
        os.close();
    }

    public static String getFilename(String path) {
        String[] folders = path.split("/");
        int size = folders.length;
        return size == 0 ? "" : folders[size - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static String getDigest(File file, String algorithm, int hashLength) {
        String string;
        DigestInputStream stream = null;
        try {
            int read;
            stream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance(algorithm));
            byte[] ignored = new byte[65536];
            while ((read = stream.read(ignored)) > 0) {
            }
            string = String.format(Locale.ROOT, "%1$0" + hashLength + "x", new BigInteger(1, stream.getMessageDigest().digest()));
        }
        catch (Exception exception) {
            FileUtil.close(stream);
            catch (Throwable throwable) {
                FileUtil.close(stream);
                throw throwable;
            }
        }
        FileUtil.close(stream);
        return string;
        return null;
    }

    public static String getSHA(File file) {
        return FileUtil.getDigest(file, "SHA", 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyAndDigest(InputStream inputStream, OutputStream outputStream, String algorithm, int hashLength) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException var10) {
            throw new RuntimeException("Missing Digest. " + algorithm, var10);
        }
        byte[] buffer = new byte[65536];
        try {
            int read = inputStream.read(buffer);
            while (read >= 1) {
                digest.update(buffer, 0, read);
                outputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
        }
        finally {
            FileUtil.close(inputStream);
            FileUtil.close(outputStream);
        }
        return String.format(Locale.ROOT, "%1$0" + hashLength + "x", new BigInteger(1, digest.digest()));
    }

    private static byte[] createChecksum(File file, String algorithm) throws IOException {
        byte[] byArray;
        BufferedInputStream fis = null;
        try {
            int numRead;
            fis = new BufferedInputStream(new FileInputStream(file));
            byte[] e = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            do {
                if ((numRead = fis.read(e)) <= 0) continue;
                complete.update(e, 0, numRead);
            } while (numRead != -1);
            byArray = complete.digest();
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new Error(e);
            }
            catch (Throwable throwable) {
                FileUtil.close(fis);
                throw throwable;
            }
        }
        FileUtil.close(fis);
        return byArray;
    }

    public static String getChecksum0(File file, String algorithm) throws IOException {
        if (!Objects.requireNonNull(file, "file").isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        byte[] checksumBytes = FileUtil.createChecksum(file, algorithm);
        StringBuilder checksumString = new StringBuilder();
        for (byte b : checksumBytes) {
            checksumString.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return checksumString.toString();
    }

    public static String getSha1(File file) throws IOException {
        return FileUtil.getChecksum0(file, "SHA-1");
    }

    public static String getChecksum(File file, String algorithm) {
        try {
            return FileUtil.getChecksum0(file, algorithm);
        }
        catch (IOException ioE) {
            LOGGER.debug("Couldn't compute {} for {}", (Object)algorithm, (Object)file.getAbsolutePath(), (Object)ioE);
            return null;
        }
    }

    private static void close(Closeable a) {
        try {
            a.close();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    public static File getRunningJar() {
        try {
            return new File(URLDecoder.decode(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath(), DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException var1) {
            throw new RuntimeException("Cannot get running file!", var1);
        }
    }

    public static void copyFile(File source, File dest, boolean replace) throws IOException {
        if (dest.isFile()) {
            if (!replace) {
                return;
            }
        } else {
            FileUtil.createFile(dest);
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
    }

    public static void deleteFile(File file) {
        if (!file.isFile() && !file.isDirectory()) {
            return;
        }
        String path = file.getAbsolutePath();
        if (file.delete()) {
            File[] list;
            File parent = file.getParentFile();
            if (parent != null && !parent.equals(file) && (list = parent.listFiles()) != null && list.length <= 0) {
                FileUtil.deleteFile(parent);
            }
        } else if (FileUtil.fileExists(file)) {
            LOGGER.warn("Could not delete file: {}", (Object)path, (Object)new RuntimeException());
        }
    }

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + dir.getAbsolutePath());
        }
        File[] list = dir.listFiles();
        if (list == null) {
            throw new RuntimeException("Folder is corrupted: " + dir.getAbsolutePath());
        }
        for (File file : list) {
            if (file.equals(dir)) continue;
            if (file.isDirectory()) {
                FileUtil.deleteDirectory(file);
            }
            if (!file.isFile()) continue;
            FileUtil.deleteFile(file);
        }
        FileUtil.deleteFile(dir);
    }

    public static String getMd5(File file) throws IOException {
        return FileUtil.getChecksum0(file, "MD5");
    }

    /*
     * Unable to fully structure code
     */
    public byte[] getFile(File archive, String requestedFile) throws IOException {
        out = new ByteArrayOutputStream();
        try {
            in = new ZipInputStream(new FileInputStream(archive));
            try {
                block12: while (true) {
                    if ((entry = in.getNextEntry()) == null) {
                        var6_9 = out.toByteArray();
                        return var6_9;
                    }
                    if (!entry.getName().equals(requestedFile)) continue;
                    buf = new byte[1024];
                    while (true) {
                        if ((len = in.read(buf)) > 0) ** break;
                        continue block12;
                        out.write(buf, 0, len);
                    }
                    break;
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }

    public static boolean createFolder(File dir) throws IOException {
        if (dir == null) {
            throw new NullPointerException();
        }
        if (dir.isDirectory() && dir.exists()) {
            return false;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create folders: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new IOException("Created directory is not accessible: " + dir.getAbsolutePath());
        }
        return true;
    }

    public static boolean folderExists(File folder) {
        return folder != null && folder.isDirectory() && folder.exists();
    }

    public static boolean fileExists(File file) {
        return file != null && file.isFile() && file.exists();
    }

    public static boolean fileExists(String path) {
        return path != null && FileUtil.fileExists(new File(path));
    }

    public static void createFile(File file) throws IOException {
        if (FileUtil.fileExists(file)) {
            return;
        }
        if (file.getParentFile() != null && !FileUtil.folderExists(file.getParentFile()) && !file.getParentFile().mkdirs()) {
            throw new IOException("Could not create parent:" + file.getAbsolutePath());
        }
        if (!file.createNewFile() && !FileUtil.fileExists(file)) {
            throw new IOException("Could not create file, or it was created/deleted simultaneously: " + file.getAbsolutePath());
        }
    }

    public static void createFile(String file) throws IOException {
        FileUtil.createFile(new File(file));
    }

    public static String getResource(URL resource, String charset) throws IOException {
        BufferedInputStream is = new BufferedInputStream(resource.openStream());
        InputStreamReader reader = new InputStreamReader((InputStream)is, charset);
        StringBuilder b = new StringBuilder();
        while (reader.ready()) {
            b.append((char)reader.read());
        }
        reader.close();
        return b.toString();
    }

    public static String getResource(URL resource) throws IOException {
        return FileUtil.getResource(resource, DEFAULT_CHARSET);
    }

    private static File getNeighborFile(File file, String filename) {
        File parent = file.getParentFile();
        if (parent == null) {
            parent = new File("/");
        }
        return new File(parent, filename);
    }

    public static File getNeighborFile(String filename) {
        return FileUtil.getNeighborFile(FileUtil.getRunningJar(), filename);
    }

    public static String getExtension(File f) {
        if (!f.isFile() && f.isDirectory()) {
            return null;
        }
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase(Locale.ROOT);
        }
        return ext;
    }

    public static long getSize(File file) throws IOException {
        BasicFileAttributes attributes;
        Path path = file.toPath();
        BasicFileAttributeView view = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
        try {
            attributes = view.readAttributes();
        }
        catch (IOException ioE) {
            throw new IOException("Couldn't real attributes of " + file.getAbsolutePath(), ioE);
        }
        return attributes.size();
    }
}

