/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import ru.turikhay.util.http.HttpRequestRetryHandler;
import ru.turikhay.util.http.RetryingRangeContentResponseHandler;

public final class EHttpClient {
    public static HttpClientBuilder builder() {
        return HttpClients.custom().setRetryHandler((org.apache.http.client.HttpRequestRetryHandler)new HttpRequestRetryHandler()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new DefaultServiceUnavailableRetryStrategy());
    }

    public static CloseableHttpClient createRepeatable() {
        return EHttpClient.builder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Content toContent(CloseableHttpClient httpClient, Request request) throws IOException {
        try {
            Executor executor = Executor.newInstance((HttpClient)httpClient);
            Content content = (Content)executor.execute(request).handleResponse((ResponseHandler)new RetryingRangeContentResponseHandler(request, executor));
            return content;
        }
        finally {
            httpClient.close();
        }
    }

    public static Content toContent(Request request) throws IOException {
        return EHttpClient.toContent(EHttpClient.createRepeatable(), request);
    }

    public static String toString(CloseableHttpClient httpClient, Request request) throws IOException {
        return EHttpClient.toContent(httpClient, request).asString();
    }

    public static String toString(Request request) throws IOException {
        return EHttpClient.toString(EHttpClient.createRepeatable(), request);
    }

    public static Reader toReader(HttpEntity entity) throws IOException {
        InputStream input = Objects.requireNonNull(entity.getContent(), "content");
        ContentType contentType = ContentType.get((HttpEntity)entity);
        Charset charset = contentType == null || contentType.getCharset() == null ? StandardCharsets.UTF_8 : contentType.getCharset();
        return new InputStreamReader(input, charset);
    }

    private EHttpClient() {
    }
}

