/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import ru.turikhay.util.CharsetData;

public class CharsetDataHttpEntity
extends AbstractHttpEntity {
    private final CharsetData data;
    private final int attempt = 0;

    public CharsetDataHttpEntity(CharsetData data) {
        this.data = Objects.requireNonNull(data, "data");
        this.setContentType(ContentType.TEXT_PLAIN.withCharset(data.charset()).toString());
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.data.length();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.data.stream();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        Objects.requireNonNull(outStream, "outStream");
        try (InputStream inputStream = this.data.stream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outStream);
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

