/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Locale;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.HttpClientRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidStatusCodeException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthenticationResponse;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.ChildAccountException;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.CountryNotAuthorizedException;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.NoXboxAccountException;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.XSTSAuthenticationException;

public class XSTSAuthenticator
extends XboxServiceAuthStrategy {
    private static final Logger LOGGER = LogManager.getLogger(XSTSAuthenticator.class);

    public XSTSAuthenticator() {
        super(LOGGER, new HttpClientRequester<String>(xboxLiveToken -> Request.Post((String)"https://xsts.auth.xboxlive.com/xsts/authorize").bodyString(String.format(Locale.ROOT, "{\"Properties\":{\"SandboxId\":\"RETAIL\",\"UserTokens\":[\"%s\"]},\"RelyingParty\": \"rp://api.minecraftservices.com/\",\"TokenType\": \"JWT\"}", xboxLiveToken), ContentType.APPLICATION_JSON)));
    }

    XSTSAuthenticator(Requester<String> requester) {
        super(LOGGER, requester);
    }

    public XboxServiceAuthenticationResponse xstsAuthenticate(String xboxLiveToken) throws XSTSAuthenticationException, IOException {
        try {
            return (XboxServiceAuthenticationResponse)this.requestAndParse(xboxLiveToken);
        }
        catch (InvalidResponseException e) {
            XSTSAuthenticationException e1;
            JsonObject response;
            if (e instanceof InvalidStatusCodeException && ((InvalidStatusCodeException)e).getStatusCode() == 401 && (response = e.getResponseAsJson()) != null && (e1 = XSTSAuthenticator.parseXErr(response)) != null) {
                throw e1;
            }
            throw new XSTSAuthenticationException(e);
        }
    }

    private static XSTSAuthenticationException parseXErr(JsonObject response) {
        JsonElement xErr;
        if (response.has("XErr") && (xErr = response.get("XErr")) instanceof JsonPrimitive) {
            String code;
            switch (code = xErr.getAsString()) {
                case "2148916233": {
                    return new NoXboxAccountException();
                }
                case "2148916235": {
                    return new CountryNotAuthorizedException();
                }
                case "2148916238": {
                    return new ChildAccountException();
                }
            }
        }
        return null;
    }
}

