/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.exceptions.ParseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Parser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Validatable;

public abstract class RequestAndParseStrategy<A, V extends Validatable> {
    private final Logger logger;
    private final Requester<A> requester;
    private final Parser<V> parser;

    protected RequestAndParseStrategy(Logger logger, Requester<A> requester, Parser<V> parser) {
        this.logger = logger;
        this.requester = requester;
        this.parser = parser;
    }

    protected V requestAndParse(A argument) throws IOException, InvalidResponseException {
        String response = this.requester.makeRequest(this.logger, argument);
        try {
            return this.parser.parseResponse(this.logger, response);
        }
        catch (ParseException e) {
            throw new InvalidResponseException(response, e);
        }
    }
}

