/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr;

import java.io.IOException;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidStatusCodeException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;
import ru.turikhay.util.EHttpClient;

public class HttpClientRequester<A>
implements Requester<A> {
    private final Executor requestExecutor;
    private final Function<A, Request> requestFactory;

    public HttpClientRequester(Executor requestExecutor, Function<A, Request> requestFactory) {
        this.requestExecutor = requestExecutor;
        this.requestFactory = requestFactory;
    }

    public HttpClientRequester(Function<A, Request> requestFactory) {
        this(Executor.newInstance((HttpClient)EHttpClient.createRepeatable()), requestFactory);
    }

    @Override
    public String makeRequest(Logger logger, A argument) throws InvalidResponseException, IOException {
        Request request = this.requestFactory.apply(argument);
        logger.trace("Sending request: {}", (Object)request);
        HttpResponse httpResponse = this.requestExecutor.execute(request).returnResponse();
        logger.trace("Reading response");
        String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        logger.trace("Response: {}", (Object)response);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        logger.trace("Status code: {}", (Object)statusCode);
        if (statusCode >= 200 && statusCode <= 299) {
            return response;
        }
        throw new InvalidStatusCodeException(statusCode, response);
    }
}

