/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.preq.create;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.MinecraftProfileCreateException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.GsonParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.HttpClientRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Parser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.RequestAndParseStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;

public class ProfileCreateRequest
extends RequestAndParseStrategy<MinecraftServicesToken, MinecraftOAuthProfile> {
    private static final Logger LOGGER = LogManager.getLogger(ProfileCreateRequest.class);

    public ProfileCreateRequest(String name) {
        this(new HttpClientRequester<MinecraftServicesToken>(token -> Request.Post((String)"https://api.minecraftservices.com/minecraft/profile").bodyString(ProfileCreateRequest.profileName(name), ContentType.APPLICATION_JSON).addHeader("Authorization", "Bearer " + token.getAccessToken())));
    }

    ProfileCreateRequest(Requester<MinecraftServicesToken> requester) {
        this(requester, GsonParser.withDashlessUUIDAdapter(MinecraftOAuthProfile.class));
    }

    ProfileCreateRequest(Requester<MinecraftServicesToken> requester, Parser<MinecraftOAuthProfile> parser) {
        super(LOGGER, requester, parser);
    }

    public MinecraftOAuthProfile createProfile(MinecraftServicesToken token) throws MinecraftProfileCreateException, IOException {
        try {
            return (MinecraftOAuthProfile)this.requestAndParse(token);
        }
        catch (InvalidResponseException e) {
            throw new MinecraftProfileCreateException(e);
        }
    }

    private static String profileName(String name) {
        JsonObject object = new JsonObject();
        object.addProperty("profileName", name);
        return new Gson().toJson((JsonElement)object);
    }
}

