/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.preq.create;

import java.io.IOException;
import java.util.function.Function;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.MinecraftProfileCreateException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.ProfileCreateRequest;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.ProfileCreationAbortedException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.ProfileCreatorUserInterface;

public class MinecraftProfileCreator {
    private final ProfileCreatorUserInterface userInterface;
    private final Function<String, ProfileCreateRequest> createRequestFactory;

    public MinecraftProfileCreator(ProfileCreatorUserInterface userInterface, Function<String, ProfileCreateRequest> createRequestFactory) {
        this.userInterface = userInterface;
        this.createRequestFactory = createRequestFactory;
    }

    public MinecraftProfileCreator(ProfileCreatorUserInterface userInterface) {
        this(userInterface, ProfileCreateRequest::new);
    }

    public MinecraftOAuthProfile createProfile(MinecraftServicesToken token) throws IOException, ProfileCreationAbortedException {
        while (true) {
            String profileName;
            if ((profileName = this.userInterface.requestProfileName()) == null) {
                throw new ProfileCreationAbortedException();
            }
            try {
                return this.createRequestFactory.apply(profileName).createProfile(token);
            }
            catch (MinecraftProfileCreateException e) {
                this.userInterface.showProfileUnavailableMessage(profileName);
                continue;
            }
            break;
        }
    }
}

