/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.preq;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.http.client.fluent.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.ProfileNotCreatedException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.GsonParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.HttpClientRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Parser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.RequestAndParseStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;

public class MinecraftProfileRequester
extends RequestAndParseStrategy<MinecraftServicesToken, MinecraftOAuthProfile> {
    private static final Logger LOGGER = LogManager.getLogger(MinecraftProfileRequester.class);

    public MinecraftProfileRequester() {
        this(new HttpClientRequester<MinecraftServicesToken>(token -> Request.Get((String)"https://api.minecraftservices.com/minecraft/profile").addHeader("Authorization", "Bearer " + token.getAccessToken())));
    }

    MinecraftProfileRequester(Requester<MinecraftServicesToken> requester) {
        this(requester, GsonParser.withDashlessUUIDAdapter(MinecraftOAuthProfile.class));
    }

    MinecraftProfileRequester(Requester<MinecraftServicesToken> requester, Parser<MinecraftOAuthProfile> parser) {
        super(LOGGER, requester, parser);
    }

    public MinecraftOAuthProfile requestProfile(MinecraftServicesToken token) throws MinecraftProfileRequestException, IOException {
        try {
            return (MinecraftOAuthProfile)this.requestAndParse(token);
        }
        catch (InvalidResponseException e) {
            JsonObject response = e.getResponseAsJson();
            JsonElement errorElement = response.get("error");
            if (errorElement != null && errorElement.isJsonPrimitive() && "NOT_FOUND".equals(errorElement.getAsString())) {
                throw new ProfileNotCreatedException(e);
            }
            throw new MinecraftProfileRequestException(e);
        }
    }
}

